package com.biz.crm.market.business.bidding.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 中标状态
 * @author hezhiheng
 * @date 2022.11.02
 */
@Getter
@AllArgsConstructor
public enum BidStatusEnum {
    /** 挂网成功 */
    CONNECT_SUCCESS("connect_success","挂网成功"),
    /** 挂网不挂价 */
    CONNECT_NOT_PRICE("connect_not_price","挂网不挂价"),
//    /** 未挂网成功 */
//    CONNECT_FAIL("connect_fail","未挂网成功"),
    /** 未挂网 */
    NOT_CONNECT("not_connect","未挂网"),
    ;

    private String code;
    private String des;

    /**
     * 根据code获取枚举
     *
     * @param code
     * @return
     */
    public static BidStatusEnum getByKey(String code) {
        return Arrays.stream(BidStatusEnum.values()).filter(item -> Objects.equals(item.getCode(), code))
                .findFirst().orElse(null);
    }
}
