package com.biz.crm.market.business.bidding.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 附件类型
 * @author hezhiheng
 * @date 2022.10.27
 */
@Getter
@AllArgsConstructor
public enum BiddingProcessStatusEnum {
    /** 草稿 */
    DRAFT("draft","草稿"),
    /** 已提交 */
    SUBMITTED("submitted","已提交"),
    ;

    private String code;
    private String des;

    /**
     * 根据code获取枚举
     *
     * @param code
     * @return
     */
    public static BiddingProcessStatusEnum getByKey(String code) {
        return Arrays.stream(BiddingProcessStatusEnum.values()).filter(item -> Objects.equals(item.getCode(), code))
                .findFirst().orElse(null);
    }

}
