package com.biz.crm.market.business.bidding.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 生效状态
 * @author hezhiheng
 * @date 2022.10.27
 */
@Getter
@AllArgsConstructor
public enum EffectiveStatusEnum {
    /** 草稿 */
    DRAFT("draft","草稿"),
    /** 未生效 */
    NOT_EFFECTIVE("not_effective","未生效"),
    /** 待执行 */
    PENDING("pending","待执行"),
    /** 执行中 */
    EXECUTING("executing","执行中"),
    /** 历史 */
    HISTORY("history","历史"),
    ;

    private String code;
    private String des;

    /**
     * 根据code获取枚举
     *
     * @param code
     * @return
     */
    public static EffectiveStatusEnum getByKey(String code) {
        return Arrays.stream(EffectiveStatusEnum.values()).filter(item -> Objects.equals(item.getCode(), code))
                .findFirst().orElse(null);
    }
}
