package com.biz.crm.market.business.bidding.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 采招类型
 *
 * @author hezhiheng
 * @date 2022.10.27
 */
@Getter
@AllArgsConstructor
public enum RecruitmentTypeEnum {
    /**
     * 带量采购-国家
     */
    QUANTITY_PURCHASE_NATIONAL("quantity_purchase_national", "带量采购-国家"),
    /**
     * 带量采购-省级
     */
    QUANTITY_PURCHASE_PROVINCIAL("quantity_purchase_provincial", "带量采购-省级"),
    /**
     * 带量采购-省际
     */
    QUANTITY_PURCHASE_INTERPROVINCIAL("quantity_purchase_interprovincial", "带量采购-省际"),
    /**
     * 省标-价格联动
     */
    PROVINCIAL_STANDARD_PRICE_LINKAGE("provincial_standard_price_linkage", "省标-价格联动"),
    /**
     * 省标-挂网
     */
    PROVINCIAL_STANDARD_BIDDING_ONLINE("provincial_standard_bidding_online", "省标-挂网"),
    /**
     * 特殊-市标
     */
    SPECIAL_MUNICIPAL_STANDARD("special_municipal_standard", "特殊-市标"),
    /**
     * 特殊-其他
     */
    SPECIAL_OTHER("special_other", "特殊-其他"),
    ;

    private String code;
    private String des;

    /**
     * 根据code获取枚举
     *
     * @param code
     * @return
     */
    public static RecruitmentTypeEnum getByKey(String code) {
        return Arrays.stream(RecruitmentTypeEnum.values()).filter(item -> Objects.equals(item.getCode(), code))
                .findFirst().orElse(null);
    }

}
