package com.biz.crm.market.business.bidding.sdk.event;

import com.biz.crm.market.business.bidding.sdk.dto.BidProjectDictEventDto;
import com.biz.crm.market.business.bidding.sdk.dto.BiddingProcessLogEventDto;
import com.biz.crm.market.business.bidding.sdk.vo.BidProjectDictVo;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * @author hezhiheng
 * @describe:
 * @createTime 2022.11.08
 */
public interface BiddingProjectDictLogEventListener extends NebulaEvent {

    /**
     * 当创建时触发
     *
     * @param dto 创建时的vo
     */
    void onCreate(BidProjectDictEventDto dto);

    /**
     * 当修改时触发
     *
     * @param dto
     */
    void onUpdate(BidProjectDictEventDto dto);

    /**
     * 当禁用时触发
     *
     * @param dtos 禁用dto信息
     */
    void onDisable(List<BidProjectDictEventDto> dtos);

    /**
     * 当启用时触发
     *
     * @param dtos 启用dto信息
     */
    void onEnable(List<BidProjectDictEventDto> dtos);

    /**
     * 当批量删除时触发删除事件
     *
     * @param dtos
     */
    void onDeleteBatch(List<BidProjectDictEventDto> dtos);
}
