package com.biz.crm.market.business.bidding.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.market.business.bidding.sdk.dto.BiddingProcessDetailSelectDto;
import com.biz.crm.market.business.bidding.sdk.dto.ReferencePriceSelectDto;
import com.biz.crm.market.business.bidding.sdk.vo.BiddingProcessDetailVo;
import com.biz.crm.market.business.bidding.sdk.vo.ReferencePriceSelectVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 招标过程明细VO服务接口
 *
 * @author hezhiheng
 * @date 2022.10.27
 */
public interface BiddingProcessDetailVoService {


    /**
     * 根据编码查询
     *
     * @param selectDto 查询条件dto
     * @return 返回页面展示用招标过程明细集合
     */
    List<BiddingProcessDetailVo> findBySelectDto(BiddingProcessDetailSelectDto selectDto);

    /**
     * 根据编码查询带翻页的集合
     *
     * @param pageable  翻页对象
     * @param selectDto 查询条件dto
     * @return 返回带翻页的页面展示用招标过程明细集合
     */
    Page<BiddingProcessDetailVo> findPageBySelectDto(Pageable pageable, BiddingProcessDetailSelectDto selectDto);

    /**
     * 根据产品编号和省份编号查询最低价
     *
     * @param dtos 条件集合
     * @return 返回查询到的最低价
     */
    List<ReferencePriceSelectVo> findBidPrice(List<ReferencePriceSelectDto> dtos);

    /**
     * 根据产品编号和省份编号及生效中查询最低价
     *
     * @param dto 条件dto
     * @return 返回查询到的最低价查询对象
     */
    List<ReferencePriceSelectVo> findBidPriceByProductAndProvince(ReferencePriceSelectDto dto);
}
