package com.biz.crm.market.business.bidding.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.market.business.bidding.sdk.dto.BiddingProcessSelectDto;
import com.biz.crm.market.business.bidding.sdk.vo.BiddingProcessVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 招标过程VO服务接口
 *
 * @author hezhiheng
 * @date 2022.10.27
 */
public interface BiddingProcessVoService {

    /**
     * 根据请求参数查询
     *
     * @param pageable 翻页
     * @param dto      查询条件dto
     * @return Page<BiddingProcessVo> 带翻页的招标过程集合
     */
    Page<BiddingProcessVo> findByBiddingProcessSelectDto(Pageable pageable, BiddingProcessSelectDto dto);

    /**
     * 根据招标过程编码查询
     *
     * @param biddingProcessCode 招标过程编码
     * @return BiddingProcessVo 招标过程
     */
    public BiddingProcessVo findByCode(String biddingProcessCode);

    /**
     * 根据招标项目编码获取招标过程
     *
     * @param projectCode 招标项目编码
     * @return List<BiddingProcessVo> 招标过程集合
     */
    List<BiddingProcessVo> findByProjectCode(String projectCode);
}
