package com.biz.crm.market.business.bidding.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.List;

/**
 * 招标过程产品信息实体类
 *
 * @author hezhiheng
 * @date 2022.10.27
 */
@Data

public class BiddingProcessProductVo extends UuidFlagOpVo {


        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        @ApiModelProperty("产品编码")
        private String productCode;

        @ApiModelProperty("投标企业编码")
        private String biddingEnterpriseCode;

        @ApiModelProperty("投标企业名称")
        private String biddingEnterpriseName;

        @ApiModelProperty("拟申报价")
        private BigDecimal proposedQuotation;

        @ApiModelProperty("申报建议")
        private String declarationProposal;

        @ApiModelProperty("审批结果")
        private String approvalResults;

        @ApiModelProperty("最终申报价格")
        private BigDecimal finalQuotation;

        @ApiModelProperty("中标状态")
        private String bidStatus;

        @ApiModelProperty("中标价格")
        private BigDecimal bidPrice;

        // 以下为产品冗余字段
        @ApiModelProperty("产品名称")
        private String productName;

        @ApiModelProperty("剂型编码")
        private String dosageFormCode;

        @ApiModelProperty("剂型说明")
        private String dosageFormExplain;

        @ApiModelProperty("规格")
        private String specifications;

        @ApiModelProperty("生产企业编码")
        private String enterpriseCode;

        @ApiModelProperty("生产企业名称")
        private String enterpriseName;

        @ApiModelProperty("转换系数")
        private String conversionFactor;

}
