package com.biz.crm.market.business.bidding.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.biz.crm.market.business.bidding.sdk.dto.BiddingProcessMediaDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 招标过程省份Vo
 *
 * @author hezhiheng
 * @date 2022.10.27
 */
@Data

public class BiddingProcessProvinceVo extends UuidFlagOpVo {


        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        @ApiModelProperty("省份编码")
        private String provinceCode;

        @ApiModelProperty("省份名称")
        private String provinceName;

        @ApiModelProperty("挂网平台(原区域)编码")
        private String areaCode;

        @ApiModelProperty("挂网平台(原区域)名称")
        private String areaName;

        @ApiModelProperty("公告日期")
        private String announcementDate;

        @ApiModelProperty("执行开始日期")
        @JsonFormat(
                locale = "zh",
                timezone = "GMT+8",
                pattern = "yyyy-MM-dd HH:mm:ss"
        )
        @DateTimeFormat(
                pattern = "yyyy-MM-dd HH:mm:ss"
        )
        private Date executionBeginDate;

        @ApiModelProperty("执行结束日期")
        @JsonFormat(
                locale = "zh",
                timezone = "GMT+8",
                pattern = "yyyy-MM-dd HH:mm:ss"
        )
        @DateTimeFormat(
                pattern = "yyyy-MM-dd HH:mm:ss"
        )
        private Date executionEndDate;


}
