package com.biz.crm.market.business.bidding.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.biz.crm.market.business.bidding.sdk.dto.BiddingProcessMediaDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 招标过程dto
 *
 * @author hezhiheng
 * @date 2022.10.27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "招标过程dto")
public class BiddingProcessVo extends UuidFlagOpVo {

        @ApiModelProperty("招标过程编码")
        private String biddingProcessCode;

        @ApiModelProperty("所属项目编码")
        private String projectCode;

        @ApiModelProperty("所属项目名称")
        private String projectName;

        @ApiModelProperty("所属项目说明")
        private String projectExplain;

        @ApiModelProperty("所属项目年份")
        private String projectYear;

        @ApiModelProperty("采招类型")
        private String recruitmentType;

        @ApiModelProperty("明细行数量")
        private Integer detailNum;

        @ApiModelProperty("招标过程状态")
        private String biddingProcessStatus;

        @ApiModelProperty("招标过程产品信息")
        private List<BiddingProcessProductVo> biddingProcessProductVos;

        @ApiModelProperty("招标过程省份")
        private List<BiddingProcessProvinceVo> biddingProcessProvinceVos;

        @ApiModelProperty("项目明细")
        private List<BiddingProcessDetailVo> BiddingProcessDetailVos;

        @ApiModelProperty("招标附件")
        private List<BiddingProcessMediaVo> biddingProcessMedias;

        @ApiModelProperty("产品附件")
        private List<BiddingProcessMediaVo> biddingProcessProductMedias;

        @ApiModelProperty("省份附件")
        private List<BiddingProcessMediaVo> biddingProcessProvinceMedias;

}
