package com.biz.crm.mdm.admin.web.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.biz.crm.mdm.admin.web.service.SmsVerificationCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 管理端发送手机号验证码相关接口
 *
 * @author pengxi
 * @date 2022/05/10
 */
@Slf4j
@RestController
@RequestMapping("/v1/smsVerificationCode/smsVerificationCode")
@Api(tags = "管理端发送手机号验证码相关接口")
public class SmsVerificationCodeController {

  @Autowired(required = false)
  private SmsVerificationCodeService smsVerificationCodeService;

  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;

  @ApiOperation(value = "校验手机号验证码是否有效")
  @PostMapping("/checkVerificationCode")
  public Result checkVerificationCode(
      @RequestParam(value = "appType") @ApiParam(name = "appType", required = true, value = "业务系统类型") Integer appType,
      @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone,
      @RequestParam(value = "verificationCode") @ApiParam(name = "verificationCode", required = true, value = "短信验证码") String verificationCode) {
    try {
      Boolean bool = this.validitySmsCodeService.isAvailableVerificationCode(phone, verificationCode);
      return Result.ok(bool);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "发送【手机号+验证码登录时】手机号验证码")
  @PostMapping("/sendPhoneLoginVerificationCode")
  public Result sendPhoneLoginVerificationCode(
      @RequestParam(value = "appType") @ApiParam(name = "appType", required = true, value = "业务系统类型") Integer appType,
      @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone) {
    try {
      this.smsVerificationCodeService.phoneLoginVerificationCode(appType, phone);
      return Result.ok("验证码发送成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "发送【找回密码时】手机号验证码")
  @PostMapping("/sendRetrievePasswordVerificationCode")
  public Result sendRetrievePasswordVerificationCode(
      @RequestParam(value = "appType") @ApiParam(name = "appType", required = true, value = "业务系统类型") Integer appType,
      @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone) {
    try {
      this.smsVerificationCodeService.retrievePasswordVerificationCode(appType, phone);
      return Result.ok("验证码发送成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
