package com.biz.crm.mdm.admin.web.deprecated.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.deprecated.mapper.MdmPositionMapper;
import com.biz.crm.mdm.admin.web.deprecated.service.MdmPositionService;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.org.sdk.common.constant.OrgCodeConstant;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionCurrentUserDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserOrgDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserOrgPageDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.enums.PositionOperationEnum;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmOrgVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionDetailVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionPageVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionUserOrgPageVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionUserOrgVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmRoleVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.AbstractRelationView;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.position.level.sdk.service.PositionLevelVoService;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 老版MDM职位接口实现类
 *
 * @author ning.zhang
 * @date 2021/10/18
 */
@Service
@Slf4j
@Deprecated
public class MdmPositionServiceImpl implements MdmPositionService {

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private PositionVoService positionVoService;
  @Autowired(required = false)
  private OrgVoService orgVoService;
  @Autowired(required = false)
  private PositionLevelVoService positionLevelVoService;
  @Autowired(required = false)
  private RoleVoCacheService roleVoCacheService;
  @Autowired(required = false)
  private MdmPositionMapper mdmPositionMapper;

  @Override
  public MdmPositionVo findByIdOrCode(String id, String positionCode) {
    if (StringUtils.isBlank(id) && StringUtils.isBlank(positionCode)) {
      return null;
    }
    List<PositionVo> list = positionVoService
        .findDetailsByIdsOrCodes(Lists.newArrayList(id), Lists.newArrayList(positionCode));
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    PositionVo vo = list.get(0);
    MdmPositionVo mdmVo = this.nebulaToolkitService.copyObjectByWhiteList(vo, MdmPositionVo.class, HashSet.class, ArrayList.class);
    Map<String, List<OrgVo>> orgMap = this.buildOrgMap(list);
    Map<String, PositionVo> parentPositionMap = this.buildParentPositionMap(list);
    Map<String, PositionLevelVo> positionLevelMap = this.buildPositionLevelMap(list);
    Map<String, List<RoleVo>> roleMap = this.buildRoleMap(list);
    List<OrgVo> orgVoList = orgMap.get(mdmVo.getPositionCode());
    if (CollectionUtils.isNotEmpty(orgVoList)) {
      OrgVo orgVo = orgVoList.get(0);
      mdmVo.setOrgCode(orgVo.getOrgCode());
      mdmVo.setOrgName(orgVo.getOrgName());
    }
    PositionVo parent = parentPositionMap.get(mdmVo.getPositionCode());
    if (Objects.nonNull(parent)) {
      mdmVo.setParentCode(parent.getPositionCode());
      mdmVo.setParentName(parent.getPositionName());
    }
    PositionLevelVo positionLevelVo = positionLevelMap.get(mdmVo.getPositionCode());
    if (Objects.nonNull(positionLevelVo)) {
      mdmVo.setPositionLevelName(positionLevelVo.getPositionLevelName());
    }
    List<RoleVo> roleVoList = roleMap.get(mdmVo.getPositionCode());
    if (CollectionUtils.isNotEmpty(roleVoList)) {
      mdmVo.setRoleList(Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(roleVoList
          , RoleVo.class, MdmRoleVo.class, HashSet.class, ArrayList.class)));
    }
    //TODO 封装用户信息
    mdmVo.setUnionName(this.generateUnionName(mdmVo.getOrgName(), mdmVo.getPositionName(), mdmVo.getFullName()));
    //fixme 流程角色还没有确定,暂时标记待处理
    return mdmVo;
  }

  @Override
  public MdmPositionDetailVo findDetailsByIdOrCode(String id, String positionCode) {
    if (StringUtils.isBlank(id) && StringUtils.isBlank(positionCode)) {
      return null;
    }
    List<PositionVo> list = positionVoService.findDetailsByIdsOrCodes(Lists.newArrayList(id), Lists.newArrayList(positionCode));
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    PositionVo vo = list.get(0);
    MdmPositionDetailVo mdmVo = this.nebulaToolkitService.copyObjectByWhiteList(vo, MdmPositionDetailVo.class, HashSet.class, ArrayList.class);
    Map<String, List<OrgVo>> orgMap = this.buildOrgMap(list);
    Map<String, List<RoleVo>> roleMap = this.buildRoleMap(list);
    List<OrgVo> orgVoList = orgMap.get(mdmVo.getPositionCode());
    if (CollectionUtils.isNotEmpty(orgVoList)) {
      OrgVo orgVo = orgVoList.get(0);
      mdmVo.setOrgCode(orgVo.getOrgCode());
      mdmVo.setOrg(this.nebulaToolkitService.copyObjectByWhiteList(orgVo, MdmOrgVo.class, HashSet.class, ArrayList.class));
    }
    List<RoleVo> roleVoList = roleMap.get(mdmVo.getPositionCode());
    if (CollectionUtils.isNotEmpty(roleVoList)) {
      mdmVo.setRoleList(Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(roleVoList
          , RoleVo.class, MdmRoleVo.class, HashSet.class, ArrayList.class)));
    }
    //TODO 封装用户信息
    //fixme 流程角色还没有确定,暂时标记待处理
    return mdmVo;
  }

  @Override
  public List<MdmPositionUserOrgVo> findDetailsByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newArrayList();
    }
    List<PositionVo> list = positionVoService.findDetailsByIdsOrCodes(ids, null);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return covertVoToMdm(list);
  }

  @Override
  public MdmPositionVo finUserPrimaryPosition(MdmPositionUserDto dto) {
    List<MdmPositionVo> mdmVoList = mdmPositionMapper.findByPositionUserDto(TenantUtils.getTenantCode(), dto);
    if (CollectionUtils.isEmpty(mdmVoList)) {
      return null;
    }
    MdmPositionVo mdmVo = null;
    for (MdmPositionVo positionItem : mdmVoList) {
      if (BooleanEnum.TRUE.getNumStr().equals(positionItem.getPrimaryFlag())) {
        mdmVo = positionItem;
      }
    }
    return mdmVo;
  }

  @Override
  public List<MdmPositionVo> getUserAllPositionList(String userName) {
    if (StringUtils.isBlank(userName)) {
      return Lists.newArrayList();
    }
    MdmPositionUserDto dto = new MdmPositionUserDto();
    dto.setUserName(userName);
    List<MdmPositionVo> list = mdmPositionMapper.findByPositionUserDto(TenantUtils.getTenantCode(), dto);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    List<PositionVo> voList = positionVoService.findByIdsOrCodes(null
        , list.stream().map(MdmPositionVo::getPositionCode).collect(Collectors.toList()));
    Map<String, List<RoleVo>> roleMap = this.buildRoleMap(voList);
    list.forEach(item -> {
      List<RoleVo> roleVoList = roleMap.get(item.getPositionCode());
      if (CollectionUtils.isNotEmpty(roleVoList)) {
        item.setRoleList(Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(roleVoList
            , RoleVo.class, MdmRoleVo.class, HashSet.class, ArrayList.class)));
      }
      item.setOperationType(PositionOperationEnum.HISTORY.getCode());
      item.setUnionName(generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName()));
      //fixme 流程角色还没有确定,暂时标记待处理
    });
    return list;
  }

  @Override
  public PageResult<MdmPositionPageVo> positionAndUserPage(MdmPositionCurrentUserDto dto) {
    //TODO 此处需要获取当前的登录人信息
    Page<MdmPositionPageVo> page = new Page<>(dto.getPageNum(), dto.getPageSize());
    //TODO 需要判断用户的类型
    List<MdmPositionPageVo> mdmPositionPageRespVos = mdmPositionMapper.findByPositionCurrentUserDto(page, dto);
    return PageResult.<MdmPositionPageVo>builder()
        .data(mdmPositionPageRespVos)
        .count(page.getTotal())
        .build();
  }

  @Override
  public PageResult<MdmPositionPageVo> findPositionAndUserByType(MdmPositionCurrentUserDto dto) {
    //TODO 此处需要获取当前的登录人信息
    //1.如果用户是企业用户,调用positionAndUserPage
    //fixme 等待用户模块
    //2.如果用户是客户用户或者经销商员工用户,将把用户当职位用(sfa会把用户当职位用了)
    return this.positionAndUserPage(dto);
  }

  @Override
  public PageResult<MdmPositionUserOrgPageVo> findPositionUserOrgPageList(MdmPositionUserOrgPageDto dto) {
    Page<MdmPositionUserOrgPageVo> page = new Page<>(dto.getPageNum(), dto.getPageSize());
    MdmPositionUserOrgDto userOrgDto = this.nebulaToolkitService.copyObjectByWhiteList(dto, MdmPositionUserOrgDto.class, HashSet.class, ArrayList.class);
    if (buildChildrenOrgCode(userOrgDto)) {
      return PageResult.<MdmPositionUserOrgPageVo>builder()
          .data(new ArrayList<>())
          .count(0L)
          .build();
    }
    if (buildChildrenPositionCode(userOrgDto)) {
      return PageResult.<MdmPositionUserOrgPageVo>builder()
          .data(new ArrayList<>())
          .count(0L)
          .build();
    }
    dto.setOrgCodeList(userOrgDto.getOrgCodeList());
    dto.setPositionCodeList(userOrgDto.getPositionCodeList());
    List<MdmPositionUserOrgPageVo> list = mdmPositionMapper.findByPositionUserOrgPageDto(page, dto);
    return PageResult.<MdmPositionUserOrgPageVo>builder()
        .data(list)
        .count(page.getTotal())
        .build();
  }

  @Override
  public List<MdmPositionUserOrgVo> findPositionUserOrgList(MdmPositionUserOrgDto dto) {
    if (buildChildrenOrgCode(dto)) {
      return Lists.newArrayList();
    }
    if (buildChildrenPositionCode(dto)) {
      return Lists.newArrayList();
    }
    return mdmPositionMapper.findByPositionUserOrgDto(TenantUtils.getTenantCode(), dto);
  }

  @Override
  public List<MdmPositionUserOrgVo> findDetailsByCodes(List<String> positionCodes) {
    if (CollectionUtils.isEmpty(positionCodes)) {
      return Lists.newArrayList();
    }
    List<PositionVo> list = positionVoService.findDetailsByIdsOrCodes(null, positionCodes);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return covertVoToMdm(list);
  }

  /**
   * 封装dto中的下级职位编码
   *
   * @param dto 封装dto
   * @return 职位封装是否有效
   */
  private boolean buildChildrenPositionCode(MdmPositionUserOrgDto dto) {
    //职位编码（查这个职位及其全部下级职位）
    if (StringUtils.isNotBlank(dto.getAllUnderThisPositionCode())) {
      List<PositionVo> childrenPositionList = this.positionVoService.findAllChildrenByCode(dto.getAllUnderThisPositionCode());
      if (CollectionUtils.isEmpty(childrenPositionList)) {
        return true;
      }
      List<String> childrenPositionCodeList = childrenPositionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toList());
      if (CollectionUtils.isEmpty(dto.getPositionCodeList())) {
        dto.setPositionCodeList(childrenPositionCodeList);
      } else {
        dto.getPositionCodeList().retainAll(childrenPositionCodeList);
      }
    }
    //职位编码（查这个职位（不含该职位）的全部下级职位
    if (StringUtils.isNotEmpty(dto.getAllUnderThisPositionCodeExcludeSelf())) {
      List<PositionVo> childrenPositionList = this.positionVoService.findAllChildrenByCode(dto.getAllUnderThisPositionCodeExcludeSelf());
      if (CollectionUtils.isEmpty(childrenPositionList) || childrenPositionList.size() == 1) {
        return true;
      }
      List<String> childrenPositionCodeList = childrenPositionList.stream().filter(item
          -> !item.getPositionCode().equals(dto.getAllUnderThisPositionCodeExcludeSelf())).map(PositionVo::getPositionCode).collect(Collectors.toList());
      if (CollectionUtils.isEmpty(dto.getPositionCodeList())) {
        dto.setPositionCodeList(childrenPositionCodeList);
      } else {
        dto.getPositionCodeList().retainAll(childrenPositionCodeList);
      }
    }
    return false;
  }

  /**
   * 封装dto中的下级组织编码
   *
   * @param dto 封装dto
   * @return 组织封装是否有效
   */
  private boolean buildChildrenOrgCode(MdmPositionUserOrgDto dto) {
    //组织编码（查这个组织及全部下级组织）
    if (StringUtils.isNotBlank(dto.getAllUnderThisOrgCode())) {
      List<OrgVo> childrenOrgList = orgVoService.findAllChildrenByOrgCode(dto.getAllUnderThisOrgCode());
      if (CollectionUtils.isEmpty(childrenOrgList)) {
        return true;
      }
      List<String> childrenOrgCodeList = childrenOrgList.stream().map(OrgVo::getOrgCode).collect(Collectors.toList());
      if (CollectionUtils.isEmpty(dto.getOrgCodeList())) {
        dto.setOrgCodeList(childrenOrgCodeList);
      } else {
        dto.getOrgCodeList().retainAll(childrenOrgCodeList);
      }
    }
    //组织编码（查这个组织（不含该组织）的全部下级组织的职位）
    if (StringUtils.isNotBlank(dto.getAllUnderThisOrgCodeExcludeSelf())) {
      List<OrgVo> childrenOrgList = orgVoService.findAllChildrenByOrgCode(dto.getAllUnderThisOrgCodeExcludeSelf());
      if (CollectionUtils.isEmpty(childrenOrgList) || childrenOrgList.size() == 1) {
        return true;
      }
      List<String> childrenOrgCodeList = childrenOrgList.stream().filter(item
          -> !item.getOrgCode().equals(dto.getAllUnderThisOrgCodeExcludeSelf())).map(OrgVo::getOrgCode).collect(Collectors.toList());
      if (CollectionUtils.isEmpty(dto.getOrgCodeList())) {
        dto.setOrgCodeList(childrenOrgCodeList);
      } else {
        dto.getOrgCodeList().retainAll(childrenOrgCodeList);
      }
    }
    return false;
  }

  /**
   * 新版VO转换老版MDM的VO
   *
   * @param list 职位列表
   * @return 老版MDM的VO
   */
  private List<MdmPositionUserOrgVo> covertVoToMdm(List<PositionVo> list) {
    List<MdmPositionUserOrgVo> mdmList = Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(list
        , PositionVo.class, MdmPositionUserOrgVo.class, HashSet.class, ArrayList.class));
    //封装职位相关信息
    Map<String, PositionVo> parentPositionMap = this.buildParentPositionMap(list);
    Map<String, List<OrgVo>> orgMap = this.buildOrgMap(list);
    Map<String, PositionLevelVo> positionLevelMap = this.buildPositionLevelMap(list);
    Map<String, List<OrgVo>> parentOrgMap = Maps.newHashMap();
    //封装父级职位相关信息
    if (!parentPositionMap.isEmpty()) {
      List<PositionVo> parentList = Lists.newArrayList(parentPositionMap.values());
      parentOrgMap = this.buildOrgMap(parentList);
    }
    for (MdmPositionUserOrgVo mdmVo : mdmList) {
      List<OrgVo> orgVoList = orgMap.get(mdmVo.getPositionCode());
      if (CollectionUtils.isNotEmpty(orgVoList)) {
        OrgVo orgVo = orgVoList.get(0);
        mdmVo.setOrgCode(orgVo.getOrgCode());
        mdmVo.setOrgName(orgVo.getOrgName());
      }
      PositionVo parent = parentPositionMap.get(mdmVo.getPositionCode());
      if (Objects.nonNull(parent)) {
        mdmVo.setParentCode(parent.getPositionCode());
        mdmVo.setParentName(parent.getPositionName());
        List<OrgVo> parentOrgList = parentOrgMap.get(parent.getPositionCode());
        if (CollectionUtils.isNotEmpty(parentOrgList)) {
          OrgVo parentOrgVo = orgVoList.get(0);
          mdmVo.setParentOrgCode(parentOrgVo.getOrgCode());
          mdmVo.setParentOrgName(parentOrgVo.getOrgName());
        }
      }
      PositionLevelVo positionLevelVo = positionLevelMap.get(mdmVo.getPositionCode());
      if (Objects.nonNull(positionLevelVo)) {
        mdmVo.setPositionLevelName(positionLevelVo.getPositionLevelName());
      }
    }
    return mdmList;
  }

  /**
   * 生成 组织名称/职位名称/用户名称
   *
   * @param orgName      组织名称
   * @param positionName 职位名称
   * @param fullName     用户名称
   * @return 组织名称/职位名称/用户名称
   */
  private String generateUnionName(String orgName, String positionName, String fullName) {
    List<String> list = Lists.newArrayList();
    list.add(ObjectUtils.defaultIfNull(orgName, ""));
    list.add(ObjectUtils.defaultIfNull(positionName, ""));
    list.add(ObjectUtils.defaultIfNull(fullName, ""));
    return String.join("/", list);
  }

  /**
   * 构建职位编码-组织信息映射
   *
   * @param voList 职位信息列表
   * @return 职位编码-组织信息映射
   */
  private Map<String, List<OrgVo>> buildOrgMap(List<PositionVo> voList) {
    Map<String, List<OrgVo>> resultMap = Maps.newHashMap();
    if (CollectionUtils.isEmpty(voList)) {
      return resultMap;
    }
    Set<String> orgCodes = Sets.newHashSet();
    voList.forEach(vo -> {
      if (CollectionUtils.isEmpty(vo.getRelationData())) {
        return;
      }
      vo.getRelationData().forEach(positionRelationVo -> {
        if (OrgCodeConstant.KEY.equals(positionRelationVo.getRelationKey()) && CollectionUtils.isNotEmpty(positionRelationVo.getRelationData())) {
          orgCodes.addAll(positionRelationVo.getRelationData().stream().map(AbstractRelationView::getCode).collect(Collectors.toList()));
        }
      });
    });
    List<String> orgCodeList = orgCodes.stream().filter(Objects::nonNull).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(orgCodeList)) {
      return resultMap;
    }
    List<OrgVo> orgList = orgVoService.findByOrgCodes(orgCodeList);
    if (CollectionUtils.isEmpty(orgList)) {
      return resultMap;
    }
    return covertOrgListToMap(voList, orgList);
  }

  /**
   * 组织列表转 职位编码-组织信息映射
   *
   * @param voList  职位列表
   * @param orgList 组织列表
   * @return 职位编码-组织信息映射
   */
  private Map<String, List<OrgVo>> covertOrgListToMap(List<PositionVo> voList, List<OrgVo> orgList) {
    Map<String, List<OrgVo>> resultMap = Maps.newHashMap();
    Map<String, OrgVo> orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (key1, key2) -> key1));
    for (PositionVo vo : voList) {
      if (CollectionUtils.isEmpty(vo.getRelationData())) {
        continue;
      }
      List<OrgVo> orgVoList = Lists.newArrayList();
      for (PositionRelationVo positionRelationVo : vo.getRelationData()) {
        if (OrgCodeConstant.KEY.equals(positionRelationVo.getRelationKey()) && CollectionUtils.isNotEmpty(positionRelationVo.getRelationData())) {
          orgVoList = positionRelationVo.getRelationData().stream().map(view
              -> orgMap.get(view.getCode())).filter(Objects::nonNull).collect(Collectors.toList());
        }
      }
      resultMap.put(vo.getPositionCode(), orgVoList);
    }
    return resultMap;
  }

  /**
   * 构建职位编码-上级职位信息映射
   *
   * @param voList 职位信息列表
   * @return 职位编码-上级职位信息映射
   */
  private Map<String, PositionVo> buildParentPositionMap(List<PositionVo> voList) {
    Map<String, PositionVo> resultMap = Maps.newHashMap();
    if (CollectionUtils.isEmpty(voList)) {
      return resultMap;
    }
    List<String> parentCodes = voList.stream().map(PositionVo::getParentCode).filter(Objects::nonNull).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(parentCodes)) {
      return resultMap;
    }
    List<PositionVo> list = positionVoService.findDetailsByIdsOrCodes(null, parentCodes);
    if (CollectionUtils.isEmpty(list)) {
      return resultMap;
    }
    Map<String, PositionVo> parentPositionMap = list.stream().collect(Collectors.toMap(PositionVo::getPositionCode, t -> t, (key1, key2) -> key1));
    resultMap = voList.stream().collect(Collectors.toMap(PositionVo::getPositionCode, t
        -> parentPositionMap.get(t.getParentCode()), (key1, key2) -> key1));
    return resultMap;
  }

  /**
   * 构建职位编码-职位级别映射
   *
   * @param voList 职位信息列表
   * @return 职位编码-职位级别映射
   */
  private Map<String, PositionLevelVo> buildPositionLevelMap(List<PositionVo> voList) {
    Map<String, PositionLevelVo> resultMap = Maps.newHashMap();
    if (CollectionUtils.isEmpty(voList)) {
      return resultMap;
    }
    List<String> positionLevelCodes = voList.stream().map(PositionVo::getPositionLevelCode).filter(Objects::nonNull).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(positionLevelCodes)) {
      return resultMap;
    }
    List<PositionLevelVo> list = positionLevelVoService.findByIdsOrCodes(null, positionLevelCodes);
    if (CollectionUtils.isEmpty(list)) {
      return resultMap;
    }
    Map<String, PositionLevelVo> positionLevelMap = list.stream().collect(Collectors.toMap(PositionLevelVo::getPositionLevelCode, t -> t, (key1, key2) -> key1));
    resultMap = voList.stream().collect(Collectors.toMap(PositionVo::getPositionCode, t
        -> positionLevelMap.get(t.getPositionLevelCode()), (key1, key2) -> key1));
    return resultMap;
  }

  /**
   * 构建职位编码-角色信息映射
   *
   * @param voList 职位信息列表
   * @return 职位编码-角色信息映射
   */
  private Map<String, List<RoleVo>> buildRoleMap(List<PositionVo> voList) {
    Map<String, List<RoleVo>> resultMap = Maps.newHashMap();
    if (CollectionUtils.isEmpty(voList)) {
      return resultMap;
    }
    Set<String> roleCodes = Sets.newHashSet();
    voList.forEach(positionVo -> {
      if (CollectionUtils.isNotEmpty(positionVo.getRoleList())) {
        roleCodes.addAll(positionVo.getRoleList());
      }
    });
    if (CollectionUtils.isEmpty(roleCodes)) {
      return resultMap;
    }
    Set<RoleVo> set = roleVoCacheService.findByTenantCodeAndRoleCodes(TenantUtils.getTenantCode(), roleCodes);
    if (CollectionUtils.isEmpty(set)) {
      return resultMap;
    }
    Map<String, RoleVo> roleMap = set.stream().collect(Collectors.toMap(RoleVo::getRoleCode, t -> t, (key1, key2) -> key1));
    for (PositionVo vo : voList) {
      if (CollectionUtils.isEmpty(vo.getRoleList())) {
        continue;
      }
      List<RoleVo> roleVoList = vo.getRoleList().stream().map(roleMap::get).filter(Objects::nonNull).collect(Collectors.toList());
      resultMap.put(vo.getPositionCode(), roleVoList);
    }
    return resultMap;
  }

}
