package com.biz.crm.mdm.admin.web.exports.position.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

/**
 * 岗位导出vo
 *
 * @author hefan
 * @date 2022/05/23
 */
@Data
@CrmExcelExport
public class PositionExportVo extends CrmExcelVo {

  /**
   * 职位编码
   */
  @CrmExcelColumn("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @CrmExcelColumn("职位名称")
  private String positionName;

  /**
   * 职位级别编码
   */
  @CrmExcelColumn("职位级别编码")
  private String positionLevelCode;

  /**
   * 职位级别名称
   */
  @CrmExcelColumn("职位级别名称")
  private String positionLevelName;

  /**
   * 所属组织名称
   */
  @CrmExcelColumn("所属组织名称")
  private String orgName;

  /**
   * 启用状态
   */
  @CrmExcelColumn("启用状态")
  private String enable;

  /**
   * 启用状态(数据库值）
   */
  private String enableStatus;

  /**
   * 上级职位名称
   */
  @CrmExcelColumn("上级职位名称")
  private String parentName;

  /**
   * 上级职位所属组织
   */
  @CrmExcelColumn("上级职位所属组织")
  private String parentOrgName;

  /**
   * 登录账号
   */
  @CrmExcelColumn("登录账号")
  private String userName;

  /**
   * 用户名
   */
  @CrmExcelColumn("用户名")
  private String fullName;

  /**
   * 角色名称集合
   */
  @CrmExcelColumn("角色名称集合")
  private String roleNameList;

  /**
   * 用户启用状态
   */
  @CrmExcelColumn("用户启用状态")
  private String userEnable;

  /**
   * 用户启用状态(数据库值）
   */
  private String userEnableStatus;



}
