package com.biz.crm.mdm.admin.web.exports.product.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.product.mapper.ProductExportMapper;
import com.biz.crm.mdm.admin.web.exports.product.model.ProductExportDto;
import com.biz.crm.mdm.admin.web.exports.product.model.ProductExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
/**
 * @author Lww
 * @describe: 商品信息导出
 * @createTime 2022年05月24日 19:05:00
 */
@Component
public class ProductExportProcess implements ExportProcess<ProductExportVo> {

  @Autowired(required = false)
  private ProductExportMapper productExportMapper;

  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  /** 商品类型 */
  private static final String DICT_PRODUCT_TYPE = "product_type";
  /** 启用禁用 */
  private static final String DICT_ENABLE = "enable_status";
  /** 上下架 */
  private static final String DICT_SHELF = "is_shelf";
  /** 是否 */
  private static final String DICT_TRUE_FALSE = "true_false";


  @Override
  public Integer getTotal(Map<String, Object> params) {
    return this.productExportMapper.getProductExportTotal(this.findTestDataDto(params));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    final ProductExportDto dto = this.findTestDataDto(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());
    final List<ProductExportVo> list = this.productExportMapper.findProductExportData(dto);
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    final Map<String, List<DictDataVo>> mapDict =
        this.dictDataVoService.findByDictTypeCodeList(
            Lists.newArrayList(DICT_ENABLE,DICT_PRODUCT_TYPE,DICT_SHELF,DICT_TRUE_FALSE));
    for (ProductExportVo item : list) {
      item.setProductType(this.findDictValue(mapDict, DICT_PRODUCT_TYPE, item.getProductType()));
      item.setEnableStatus(this.findDictValue(mapDict, DICT_ENABLE, item.getEnableStatus()));
      item.setIsShelf(this.findDictValue(mapDict, DICT_SHELF, item.getIsShelf()));
      item.setMaintenancePicture(this.findDictValue(mapDict, DICT_TRUE_FALSE, item.getMaintenancePicture()));
      item.setMaintenanceIntroduction(this.findDictValue(mapDict, DICT_TRUE_FALSE, item.getMaintenanceIntroduction()));
    }
    return JSON.parseArray(JSON.toJSONString(list));
  }

  @Override
  public Class findCrmExcelVoClass() {
    return ProductExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_PRODUCT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "mdm导出商品信息";
  }

  @Override
  public Integer getPageSize() {
    return 20000;
  }


  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private ProductExportDto findTestDataDto(Map<String, Object> params) {
    final ProductExportDto dto = new ProductExportDto();
    final Object productCode = params.get("productCode");
    if (Objects.nonNull(productCode)) {
      dto.setProductCode(productCode.toString());
    }
    final Object productName = params.get("productName");
    if (Objects.nonNull(productName)) {
      dto.setProductName(productName.toString());
    }
    final Object productLevelCode = params.get("productLevelCode");
    if (Objects.nonNull(productLevelCode)) {
      dto.setProductLevelCode(productLevelCode.toString());
    }
    final Object productType = params.get("productType");
    if (Objects.nonNull(productType)) {
      dto.setProductType(productType.toString());
    }
    final Object saleUnit = params.get("saleUnit");
    if (Objects.nonNull(saleUnit)) {
      dto.setSaleUnit(saleUnit.toString());
    }
    final Object spec = params.get("spec");
    if (Objects.nonNull(spec)) {
      dto.setSpec(spec.toString());
    }
    final Object isShelf = params.get("isShelf");
    if (Objects.nonNull(isShelf)) {
      dto.setIsShelf(isShelf.toString());
    }
    final Object enableStatus = params.get("enableStatus");
    if (Objects.nonNull(enableStatus)) {
      dto.setEnableStatus(enableStatus.toString());
    }
    final Object maintenancePicture = params.get("maintenancePicture");
    if (Objects.nonNull(maintenancePicture)) {
      dto.setMaintenancePicture(maintenancePicture.toString());
    }
    final Object maintenanceIntroduction = params.get("maintenanceIntroduction");
    if (Objects.nonNull(maintenanceIntroduction)) {
      dto.setMaintenanceIntroduction(maintenanceIntroduction.toString());
    }
    return dto;
  }

  /**
   * 获取字典值
   *
   * @param mapDict
   * @param dictTypeCode
   * @param code
   * @return
   */
  private String findDictValue(
      Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }
    final Optional<String> first =
        vos.stream()
           .filter(a -> a.getDictCode().equals(code))
           .map(DictDataVo::getDictValue)
           .findFirst();
    return first.orElse(StringUtils.EMPTY);
  }
}
