package com.biz.crm.mdm.admin.web.exports.terminal.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.terminal.mapper.TerminalExportMapper;
import com.biz.crm.mdm.admin.web.exports.terminal.model.TerminalCrmExportDto;
import com.biz.crm.mdm.admin.web.exports.terminal.model.TerminalCrmExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 终端信息导出
 *
 * @author sunx
 * @date 2022/5/13
 */
@Component
public class TerminalExportProcess implements ExportProcess<TerminalCrmExportVo> {

  @Autowired(required = false) private TerminalExportMapper terminalExportMapper;

  @Autowired(required = false) private OrgService orgService;

  @Autowired(required = false) private DictDataVoService dictDataVoService;

  /** 终端类型 */
  private static final String DICT_TERMINAL_TYPE = "terminal_type";
  /** 渠道 */
  private static final String DICT_CHANNEL = "channel";
  /** 启用禁用 */
  private static final String DICT_ENABLE = "enable_status";
  /** 审批状态 */
  private static final String DICT_PROCESS_STATUS = "bpm_status";

  @Override
  public Integer getTotal(Map<String, Object> params) {
    final TerminalCrmExportDto dto = this.findTerminalCrmExportDto(params);
    return this.terminalExportMapper.getExportTotal(dto);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    final TerminalCrmExportDto dto = this.findTerminalCrmExportDto(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());
    List<TerminalCrmExportVo> list = this.terminalExportMapper.findData(dto);
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    final Map<String, List<DictDataVo>> mapDict =
        this.dictDataVoService.findByDictTypeCodeList(
            Lists.newArrayList(DICT_CHANNEL, DICT_ENABLE, DICT_PROCESS_STATUS, DICT_TERMINAL_TYPE));
    for (TerminalCrmExportVo item : list) {
      item.setTerminalType(this.findDictValue(mapDict, DICT_TERMINAL_TYPE, item.getTerminalType()));
      item.setChannel(this.findDictValue(mapDict, DICT_CHANNEL, item.getChannel()));
      item.setEnableStatus(this.findDictValue(mapDict, DICT_ENABLE, item.getEnableStatus()));
      item.setProcessStatus(
          this.findDictValue(mapDict, DICT_PROCESS_STATUS, item.getProcessStatus()));
    }
    return JSON.parseArray(JSON.toJSONString(list));
  }

  @Override
  public String getBusinessCode() {
    return "MDM_TERMINAL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "终端导出";
  }

  @Override
  public Class findCrmExcelVoClass() {
    return TerminalCrmExportVo.class;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private TerminalCrmExportDto findTerminalCrmExportDto(Map<String, Object> params) {
    final TerminalCrmExportDto dto = new TerminalCrmExportDto();
    final Object terminalCode = params.get("terminalCode");
    if (Objects.nonNull(terminalCode)) {
      dto.setTerminalCode(terminalCode.toString());
    }
    final Object terminalName = params.get("terminalName");
    if (Objects.nonNull(terminalName)) {
      dto.setTerminalName(terminalName.toString());
    }
    final Object terminalType = params.get("terminalType");
    if (Objects.nonNull(terminalType)) {
      dto.setTerminalType(terminalType.toString());
    }
    final Object channel = params.get("channel");
    if (Objects.nonNull(channel)) {
      dto.setChannel(channel.toString());
    }
    final Object processStatus = params.get("processStatus");
    if (Objects.nonNull(processStatus)) {
      dto.setProcessStatus(processStatus.toString());
    }
    final Object enableStatus = params.get("enableStatus");
    if (Objects.nonNull(enableStatus)) {
      dto.setEnableStatus(enableStatus.toString());
    }
    final Object orgCode = params.get("orgCode");
    if (Objects.nonNull(orgCode)) {
      dto.setOrgCode(orgCode.toString());
      final Org org = this.orgService.findByOrgCode(dto.getOrgCode());
      if (Objects.nonNull(org)) {
        dto.setOrgRuleCode(org.getRuleCode());
      }
    }
    final Object provinceName = params.get("provinceName");
    if (Objects.nonNull(provinceName)) {
      dto.setProvinceName(provinceName.toString());
    }
    final Object cityName = params.get("cityName");
    if (Objects.nonNull(cityName)) {
      dto.setCityName(cityName.toString());
    }
    final Object districtName = params.get("districtName");
    if (Objects.nonNull(districtName)) {
      dto.setDistrictName(districtName.toString());
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return dto;
  }

  /**
   * 获取字典值
   *
   * @param mapDict
   * @param dictTypeCode
   * @param code
   * @return
   */
  private String findDictValue(
      Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }
    final Optional<String> first =
        vos.stream()
            .filter(a -> a.getDictCode().equals(code))
            .map(DictDataVo::getDictValue)
            .findFirst();
    return first.orElse(StringUtils.EMPTY);
  }
}
