package com.biz.crm.mdm.admin.web.exports.test.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.test.mapper.TestDataMapper;
import com.biz.crm.mdm.admin.web.exports.test.model.TestDataDto;
import com.biz.crm.mdm.admin.web.exports.test.model.TestDataVo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 测试数据导出实现
 *
 * @author sunx
 * @date 2022/5/23
 */
@Component
public class TestDataExportProcess implements ExportProcess<TestDataVo> {

  @Autowired(required = false) private TestDataMapper testDataMapper;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    return this.testDataMapper.getExportTotal(this.findTestDataDto(params));
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    final TestDataDto dto = this.findTestDataDto(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());
    final List<TestDataVo> list = this.testDataMapper.findData(dto);
    return JSON.parseArray(JSON.toJSONString(list));
  }

  @Override
  public Class findCrmExcelVoClass() {
    return TestDataVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_TEST_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "mdm导出测试";
  }

  @Override
  public Integer getPageSize() {
    return 20000;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private TestDataDto findTestDataDto(Map<String, Object> params) {
    final TestDataDto dto = new TestDataDto();
    final Object productCode = params.get("productCode");
    if (Objects.nonNull(productCode)) {
      dto.setProductCode(productCode.toString());
    }
    return dto;
  }
}
