package com.biz.crm.mdm.admin.web.imports.org;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * org导入过程
 *
 * @author hefan
 * @date 2022/05/24
 */
@Component
@Slf4j
public class OrgImportProcess  implements ImportProcess<OrgImportVo> {

  @Autowired(required = false)
  private OrgService orgService;

  @Override
  @Transactional
  public Map<Integer, String> execute(
      LinkedHashMap<Integer, OrgImportVo> data,
      TaskGlobalParamsVo paramsVo,
      Map<String, Object> params) {
    final Optional<OrgImportVo> first = data.values().stream().findFirst();
    if (!first.isPresent()) {
      return null;
    }
    OrgImportVo orgImportVo = first.get();
    Org org = new Org();
    org.setOrgCode(orgImportVo.getOrgCode());
    org.setOrgName(orgImportVo.getOrgName());
    org.setParentCode(orgImportVo.getParentCode());
    org.setTenantCode(paramsVo.getTenantCode());
    orgService.create(org);
    return null;
  }

  @Override
  public Class findCrmExcelVoClass() {
    return OrgImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "MDM_ORG_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "企业组织导入 ";
  }
}
