package com.biz.crm.mdm.admin.web.imports.position;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

/**
 * 位置导入crm签证官
 *
 * @author hefan
 * @date 2022/05/23
 */
@Data
@CrmExcelImport
public class PositionImportVo extends CrmExcelVo {

  /**
   * 职位编码
   */
  @CrmExcelColumn("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @CrmExcelColumn("职位名称")
  private String positionName;

  /**
   * 职位级别编码
   */
  @CrmExcelColumn("职位级别编码")
  private String positionLevelCode;

  /**
   * 所属组织编码
   */
  @CrmExcelColumn("所属组织编码")
  private String orgCode;
  /**
   * 上级职位编码
   */
  @CrmExcelColumn("上级职位编码")
  private String parentCode;

  /**
   * 角色编码集合，新增职位需要关联角色的时候传这个
   */
  @CrmExcelColumn("权限角色编码")
  private String roleCodeList;



}
