package com.biz.crm.mdm.admin.web.observer;

import com.biz.crm.UploadService;
import com.biz.crm.workflow.sdk.dto.CompetenceInfoDto;
import com.biz.crm.workflow.sdk.listener.CompetenceInfoListener;
import com.biz.crm.workflow.sdk.vo.response.CompetenceInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.service.CompetenceVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

/**
 * mdm为工作流提供菜单相关基础数据
 *
 * @author jerry7
 * @date 2022-04-01 15:18:12
 */
@Component
public class CompetenceListener implements CompetenceInfoListener {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private CompetenceVoService competenceVoService;

  @Autowired(required = false)
  private UploadService uploadService;

  @Override
  public CompetenceInfoResponse onFindCompetenceByCompetenceCode(CompetenceInfoDto dto) {
    CompetenceInfoResponse competenceInfoResponse = new CompetenceInfoResponse();
    if (StringUtils.isNotEmpty(dto.getCompetenceCode())) {
      CompetenceVo competenceVo = this.competenceVoService.findByCompetenceCode(dto.getCompetenceCode());
      if (ObjectUtils.isNotEmpty(competenceVo)) {
        com.biz.crm.workflow.sdk.vo.CompetenceVo vo = this.nebulaToolkitService.copyObjectByWhiteList(competenceVo, com.biz.crm.workflow.sdk.vo.CompetenceVo.class, HashSet.class, ArrayList.class);
        competenceInfoResponse.setCompetenceVos(Collections.singletonList(vo));
      }
    }
    return competenceInfoResponse;
  }
}
