package com.biz.crm.mdm.admin.web.observer;

import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrgPosition;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgPositionVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerDockingVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.workflow.sdk.dto.CustomerInfoDto;
import com.biz.crm.workflow.sdk.listener.CustomerInfoListener;
import com.biz.crm.workflow.sdk.vo.CustomerDockingInfoVo;
import com.biz.crm.workflow.sdk.vo.CustomerInfoVo;
import com.biz.crm.workflow.sdk.vo.CustomerOrgPositionVo;
import com.biz.crm.workflow.sdk.vo.response.CustomerInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * mdm为工作流提供客户相关基础数据
 *
 * @author jerry7
 * @date 2022-04-01 15:18:12
 */
@Component
public class CustomerEventListener implements CustomerInfoListener {

  @Autowired(required = false)
  private CustomerVoService customerVoService;

  @Autowired(required = false)
  private CustomerOrgPositionVoService customerOrgPositionVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public CustomerInfoResponse onFindDetail(CustomerInfoDto customerInfoDto) {
    CustomerInfoResponse customerInfoResponse = new CustomerInfoResponse();
    if (StringUtils.isEmpty(customerInfoDto.getCustomerCode())) {
      return customerInfoResponse;
    }
    CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, customerInfoDto.getCustomerCode());
    if (ObjectUtils.isEmpty(customerVo)) {
      return customerInfoResponse;
    }
    CustomerInfoVo customerInfoVo = this.nebulaToolkitService.copyObjectByBlankList(customerVo, CustomerInfoVo.class, HashSet.class, ArrayList.class);
    if (CollectionUtils.isNotEmpty(customerVo.getDockingList())) {
      List<CustomerDockingInfoVo> customerDockingInfoVos = (List<CustomerDockingInfoVo>) this.nebulaToolkitService.copyCollectionByWhiteList(customerVo.getDockingList(), CustomerDockingVo.class, CustomerDockingInfoVo.class, HashSet.class, ArrayList.class);
      customerInfoVo.setDockingList(customerDockingInfoVos);
    }
    customerInfoResponse.setCustomerInfoVo(customerInfoVo);
    return customerInfoResponse;
  }

  @Override
  public CustomerInfoResponse onFindOrgPositions(CustomerInfoDto customerInfoDto) {
    CustomerInfoResponse customerInfoResponse = new CustomerInfoResponse();
    if (StringUtils.isEmpty(customerInfoDto.getCustomerCode())) {
      return customerInfoResponse;
    }
    CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, customerInfoDto.getCustomerCode());
    if (ObjectUtils.isEmpty(customerVo)) {
      return customerInfoResponse;
    }
    List<CustomerOrgPosition> customerOrgPositions = this.customerOrgPositionVoService.findListByCustomerOrgCodes(Lists.newArrayList(customerVo.getCustomerOrgCode()));
    if (CollectionUtils.isNotEmpty(customerOrgPositions)) {
      List<CustomerOrgPositionVo> customerOrgPositionVos = (List<CustomerOrgPositionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(customerOrgPositions, CustomerOrgPosition.class, CustomerOrgPositionVo.class, HashSet.class, ArrayList.class);
      customerInfoResponse.setCustomerOrgPositionVos(customerOrgPositionVos);
    }
    return customerInfoResponse;
  }
}
