package com.biz.crm.mdm.admin.web.observer;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.workflow.sdk.dto.OrgInfoDto;
import com.biz.crm.workflow.sdk.listener.OrgInfoListener;
import com.biz.crm.workflow.sdk.vo.OrgVo;
import com.biz.crm.workflow.sdk.vo.response.OrgInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * mdm为工作流提供组织相关基础数据
 *
 * @author jerry7
 * @date 2022-04-01 15:18:12
 */
@Component
public class OrgEventListener implements OrgInfoListener {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private OrgService orgService;

  @Override
  public OrgInfoResponse findByOrgCodes(OrgInfoDto dto) {
    List<Org> orgList = this.orgService.findByOrgCodes(dto.getOrgCodes());
    List<OrgVo> orgVoList = Lists.newArrayList();
    if (CollectionUtils.isNotEmpty(orgList)) {
      orgVoList = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgList, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
    }
    OrgInfoResponse orgInfoResponse = new OrgInfoResponse();
    orgInfoResponse.setRoleInfoVos(orgVoList);
    return orgInfoResponse;
  }

  @Override
  public OrgInfoResponse findAllParentByOrgCodes(OrgInfoDto dto) {
    List<Org> orgList = this.orgService.findAllParentByOrgCodes(dto.getOrgCodes());
    List<OrgVo> orgVoList = Lists.newArrayList();
    if (CollectionUtils.isNotEmpty(orgList)) {
      orgVoList = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgList, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
    }
    OrgInfoResponse orgInfoResponse = new OrgInfoResponse();
    orgInfoResponse.setRoleInfoVos(orgVoList);
    return orgInfoResponse;
  }

  @Override
  public OrgInfoResponse onFindByConditions(OrgInfoDto dto) {
    //1.构造组织报表请求参数，并获取职位报表数据
    Pageable pageable = PageRequest.of(dto.getPage(), dto.getSize());
    OrgPaginationDto pageDto = new OrgPaginationDto();
    pageDto.setOrgName(dto.getOrgName());
    pageDto.setOrgCode(dto.getOrgCode());
    pageDto.setOrgType(dto.getOrgType());
    Page<Org> page = this.orgService.findByConditions(pageable, pageDto);
    //2.构造返回分页实体，并组装数据
    Page<OrgVo> orgVoPage = new Page<>();
    orgVoPage.setSize(page.getSize());
    orgVoPage.setCurrent(page.getCurrent());
    orgVoPage.setTotal(page.getTotal());
    //3.转换数据
    if (ObjectUtils.isNotEmpty(page) && CollectionUtils.isNotEmpty(page.getRecords())) {
      List<OrgVo> voList = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(page.getRecords(), Org.class, OrgVo.class, HashSet.class, ArrayList.class);
      orgVoPage.setRecords(voList);
    }
    OrgInfoResponse orgInfoResponse = new OrgInfoResponse();
    orgInfoResponse.setOrgVoPage(orgVoPage);
    return orgInfoResponse;
  }
}
