package com.biz.crm.mdm.admin.web.observer;

import com.biz.crm.workflow.sdk.dto.RoleInfoDto;
import com.biz.crm.workflow.sdk.listener.RoleInfoListener;
import com.biz.crm.workflow.sdk.vo.RoleInfoVo;
import com.biz.crm.workflow.sdk.vo.response.RoleInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.rbac.local.dto.RoleConditionDto;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.service.RoleService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * mdm为工作流提供角色相关基础数据
 *
 * @author jerry7
 * @date 2022-04-01 15:18:12
 */
@Component
public class RoleEventListener implements RoleInfoListener {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private RoleService roleService;


  @Override
  public RoleInfoResponse onFindByConditions(RoleInfoDto dto) {
    //1.构造分页查询实体并查询数据
    Pageable pageable = PageRequest.of(dto.getPage(), dto.getSize());
    Page<RoleEntity> page = this.roleService.findByConditions(new RoleConditionDto(), pageable);
    //2.构造返回分页实体，并组装数据
    com.baomidou.mybatisplus.extension.plugins.pagination.Page<RoleInfoVo> roleInfoVoPage = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
    roleInfoVoPage.setSize(page.getSize());
    roleInfoVoPage.setCurrent(page.getTotalPages());
    roleInfoVoPage.setTotal(page.getTotalElements());
    //3.转换数据
    if (ObjectUtils.isNotEmpty(page) && CollectionUtils.isNotEmpty(page.getContent())) {
      List<RoleInfoVo> voList = (List<RoleInfoVo>) this.nebulaToolkitService.copyCollectionByWhiteList(page.getContent(), RoleEntity.class, RoleInfoVo.class, HashSet.class, ArrayList.class);
      roleInfoVoPage.setRecords(voList);
    }
    RoleInfoResponse roleInfoResponse = new RoleInfoResponse();
    roleInfoResponse.setRoleInfoVoPage(roleInfoVoPage);
    return roleInfoResponse;
  }
}
