package com.biz.crm.mdm.admin.web.observer;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.user.dto.UserReportDto;
import com.biz.crm.mdm.admin.web.report.user.service.internal.UserReportVoServiceImpl;
import com.biz.crm.mdm.admin.web.report.user.vo.UserReportVo;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.workflow.sdk.dto.UserInfoDto;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;

import java.util.*;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * mdm为工作流提供用户相关基础数据
 *
 * @author jerry7
 * @date 2022-04-01 15:18:12
 */
@Component
public class UserEventListener implements UserInfoListener {

  @Autowired(required = false)
  private UserInfoVoService userInfoVoService;

  @Autowired(required = false)
  private UserReportVoServiceImpl userReportVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public UserInfoResponse onFindByConditions(UserInfoDto userInfoDto) {
    List<UserInfoVo> userInfoVos = Lists.newArrayList();
    if (CollectionUtils.isNotEmpty(userInfoDto.getPositionCodes())) {
      userInfoVos.addAll(this.userInfoVoService.findByPositionCodes(userInfoDto.getPositionCodes()));
    }
    if (CollectionUtils.isNotEmpty(userInfoDto.getUserNames())) {
      userInfoVos.addAll(this.userInfoVoService.findByUserNames(new HashSet<>(userInfoDto.getUserNames())));
    }
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (CollectionUtils.isNotEmpty(userInfoVos)) {
      List<com.biz.crm.workflow.sdk.vo.UserInfoVo> voList = (List<com.biz.crm.workflow.sdk.vo.UserInfoVo>) this.nebulaToolkitService.copyCollectionByBlankList(userInfoVos, UserInfoVo.class, com.biz.crm.workflow.sdk.vo.UserInfoVo.class, LinkedHashSet.class, ArrayList.class);
      userInfoResponse.setUserInfoVoList(voList);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse onFindByPositionLevelCodeAndOrg(UserInfoDto userInfoDto) {
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    UserReportDto reportDto = new UserReportDto();
    reportDto.setPositionLevelCode(userInfoDto.getPositionLevelCode());
    reportDto.setOrgCode(userInfoDto.getOrgCode());
    Page<UserReportVo> reportVoPage = this.userReportVoService.findByConditions(PageRequest.of(0, 500), reportDto);
    if (CollectionUtils.isNotEmpty(reportVoPage.getRecords())) {
      List<com.biz.crm.workflow.sdk.vo.UserInfoVo> voList = (List<com.biz.crm.workflow.sdk.vo.UserInfoVo>) this.nebulaToolkitService.copyCollectionByBlankList(reportVoPage.getRecords(), UserReportVo.class, com.biz.crm.workflow.sdk.vo.UserInfoVo.class, LinkedHashSet.class, ArrayList.class);
      userInfoResponse.setUserInfoVoList(voList);
    }
    return userInfoResponse;
  }
}
