package com.biz.crm.mdm.admin.web.report.customer.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.customer.dto.AbstractCustomerPageDto;
import com.biz.crm.mdm.admin.web.report.customer.mapper.CustomerReportMapper;
import com.biz.crm.mdm.admin.web.report.customer.vo.CustomerPageVo;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerClientDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerClientVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 客户复杂报表数据库访问类
 *
 * @author ning.zhang
 * @date 2021/11/4
 */
@Component
public class CustomerReportRepository {

  @Autowired(required = false)
  private CustomerReportMapper customerReportMapper;

  /**
   * 客户分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CustomerPageVo> 客户分页列表
   */
  public Page<CustomerPageVo> findByConditions(Pageable pageable, AbstractCustomerPageDto dto) {
    Page<CustomerPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.customerReportMapper.findByConditions(page, dto);
  }

  /**
   * 查询当前用户及其下属所关联的客户信息分页列表
   * <p>
   * 用户账号和租户必传
   *
   * @param dto      查询对象
   * @param pageable 分页信息
   * @return Page<CustomerClientVo> 查询当前用户及其下属所关联的客户信息分页列表
   */
  public Page<CustomerClientVo> findChildrenPageByCustomerClientDto(Pageable pageable, CustomerClientDto dto) {
    Page<CustomerClientVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.customerReportMapper.findChildrenPageByCustomerClientDto(page, dto);
  }
}
