package com.biz.crm.mdm.admin.web.report.customer.user.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.RelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.service.CustomerUserRRoleReportVoService;
import com.biz.crm.mdm.admin.web.report.customer.user.vo.CustomerUserRRoleReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/12
 */
@Slf4j
@Api(tags = "客户用户: CustomerUserRRoleReportVo: 客户用户角色绑定相关")
@RestController
@RequestMapping(value = {"/v1/customerUser/report"})
public class CustomerUserRelaRoleReportVoController {

  @Autowired(required = false)
  private CustomerUserRRoleReportVoService customerUserRRoleReportVoService;

  /**
   * 获取已关联当前角色的客户用户分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "客户角色关联分页接口-已关联当前")
  @GetMapping("/findByRelaCurCustomerUserDto")
  public Result<Page<CustomerUserRRoleReportVo>> findByRelaCurCustomerUserDto(
      @PageableDefault(50) Pageable pageable,
      RelaCurCustomerUserDto dto) {
    try {
      return Result.ok(this.customerUserRRoleReportVoService
          .findByRelaCurCustomerUserDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取未关联当前角色的客户用户分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "客户角色关联分页接口-未关联当前")
  @GetMapping("/findByNoRelaCurCustomerUserDto")
  public Result<Page<CustomerUserRRoleReportVo>> findByNoRelaCurCustomerUserDto(
      @PageableDefault(50) Pageable pageable,
      NoRelaCurCustomerUserDto dto) {
    try {
      return Result.ok(this.customerUserRRoleReportVoService
          .findByNoRelaCurCustomerUserDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取未关联任何角色的客户用户分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "客户角色关联分页接口-未关联任何")
  @GetMapping("/findByNoRelaCustomerUserDto")
  public Result<Page<CustomerUserRRoleReportVo>> findByNoRelaCustomerUserDto(
      @PageableDefault(50) Pageable pageable,
      NoRelaCustomerUserDto dto) {
    try {
      return Result.ok(this.customerUserRRoleReportVoService
          .findByNoRelaCustomerUserDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
