package com.biz.crm.mdm.admin.web.report.customer.user.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.RelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.vo.CustomerUserRRoleReportVo;
import org.apache.ibatis.annotations.Param;

/**
 * 客户用户关联角色
 *
 * @author sunx
 * @date 2021/11/12
 */
public interface CustomerUserRRoleReportMapper {

  /**
   * 客户角色关联分页-已关联当前
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CustomerUserRRoleReportVo> findByRelaCurCustomerUserDto(
      Page<CustomerUserRRoleReportVo> page,
      @Param("dto") RelaCurCustomerUserDto dto);

  /**
   * 客户角色关联分页-未关联当前
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CustomerUserRRoleReportVo> findByNoRelaCurCustomerUserDto(
      Page<CustomerUserRRoleReportVo> page,
      @Param("dto") NoRelaCurCustomerUserDto dto);

  /**
   * 客户角色关联分页-未关联任何
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CustomerUserRRoleReportVo> findByNoRelaCustomerUserDto(
      Page<CustomerUserRRoleReportVo> page,
      @Param("dto") NoRelaCustomerUserDto dto);
}
