package com.biz.crm.mdm.admin.web.report.customermaterial.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.customermaterial.repository.CustomerMaterialVoRepository;
import com.biz.crm.mdm.admin.web.report.customermaterial.service.CustomerMaterialVoService;
import com.biz.crm.mdm.admin.web.report.customermaterial.vo.CustomerMaterialVo;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.material.sdk.dto.CustomerMaterialDto;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author jerry7
 * 客户物料VO service实现类
 */
@Service
public class CustomerMaterialVoServiceImpl implements CustomerMaterialVoService {

  @Autowired(required = false)
  private CustomerMaterialVoRepository customerMaterialVoRepository;

  @Override
  public Page<CustomerMaterialVo> findByConditions(Pageable pageable, CustomerMaterialDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new CustomerMaterialDto());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<CustomerMaterialVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.customerMaterialVoRepository.findByConditions(page, dto);
  }
}
