package com.biz.crm.mdm.admin.web.report.position.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.position.dto.AbstractPositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.repository.PositionReportRepository;
import com.biz.crm.mdm.admin.web.report.position.service.PositionPageVoService;
import com.biz.crm.mdm.admin.web.report.position.strategy.PositionReportStrategy;
import com.biz.crm.mdm.admin.web.report.position.vo.PositionPageVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 职位分页VO接口实现类
 *
 * @author ning.zhang
 * @date 2021/11/4
 */
@Service
@Slf4j
public class PositionPageVoServiceImpl implements PositionPageVoService {

  private Map<String, PositionReportStrategy> strategyMap;
  @Autowired(required = false)
  private PositionReportRepository positionReportRepository;


  public PositionPageVoServiceImpl(List<PositionReportStrategy> itemStrategies) {
    strategyMap = Maps.newHashMap();
    if (CollectionUtils.isEmpty(itemStrategies)) {
      return;
    }
    itemStrategies.forEach(strategy -> {
      PositionReportStrategy itemStrategy = strategyMap.get(strategy.getPageSource());
      Validate.isTrue(Objects.isNull(itemStrategy), String.format("存在相同的报表数据策略[%s]", strategy.getPageSource()));
      strategyMap.put(strategy.getPageSource(), strategy);
    });
  }

  @Override
  public Page<PositionPageVo> findByConditions(Pageable pageable, AbstractPositionPageDto dto) {
    PositionReportStrategy strategy = strategyMap.get(dto.getPageSource());
    //1.策略不存在获取请求参数封装结果不通过,直接返回null
    if (Objects.isNull(strategy)) {
      log.info("职位报表策略不存在....");
      return null;
    }
    if (!strategy.onRequest(dto)) {
      log.info("职位报表参数封装校验不通过....");
      return null;
    }
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto.setTenantCode(TenantUtils.getTenantCode());
    //2.获取报表数据
    Page<PositionPageVo> resultPage = this.positionReportRepository.findByConditions(pageable, dto);
    if (CollectionUtils.isEmpty(resultPage.getRecords())) {
      return resultPage;
    }
    //3.职位报表数据返回封装
    strategy.onReturn(resultPage.getRecords());
    return resultPage;
  }
}
