package com.biz.crm.mdm.admin.web.report.position.strategy.helper;

import com.biz.crm.mdm.admin.web.report.position.vo.PositionPageVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 职位报表策略辅助类
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
@Component
public class PositionReportStrategyHelper {

  @Autowired(required = false)
  private PositionVoService positionVoService;
  @Autowired(required = false)
  private RoleVoCacheService roleVoCacheService;
  @Autowired(required = false)
  private UserInfoVoService userInfoVoService;
  @Autowired(required = false)
  private OrgPositionVoService orgPositionVoService;
  @Autowired(required = false)
  private OrgVoService orgVoService;

  /**
   * 封装职位报表数据组合名称
   *
   * @param voList 职位报表数据
   */
  public void buildUnionName(List<PositionPageVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    voList.forEach(positionPageVo -> {
      positionPageVo.setUnionName(String.format("%s/%s/%s"
          , StringUtils.isNotBlank(positionPageVo.getOrgName()) ? positionPageVo.getOrgName() : ""
          , StringUtils.isNotBlank(positionPageVo.getPositionName()) ? positionPageVo.getPositionName() : ""
          , StringUtils.isNotBlank(positionPageVo.getFullName()) ? positionPageVo.getFullName() : ""
          )
      );
    });
  }

  /**
   * 封装职位报表数据角色信息
   *
   * @param voList 职位报表数据
   */
  public void buildRoleInfo(List<PositionPageVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> positionCodes = voList.stream().map(PositionPageVo::getPositionCode).collect(Collectors.toList());
    List<PositionVo> positionVos = this.positionVoService.findByIdsOrCodes(null, positionCodes);
    if (CollectionUtils.isEmpty(positionVos)) {
      return;
    }
    Set<String> roleCodes = Sets.newHashSet();
    positionVos.forEach(positionVo -> {
      if (!CollectionUtils.isEmpty(positionVo.getRoleList())) {
        roleCodes.addAll(positionVo.getRoleList());
      }
    });
    if (CollectionUtils.isEmpty(roleCodes)) {
      return;
    }
    Set<RoleVo> roleVoSet = roleVoCacheService.findByTenantCodeAndRoleCodes(TenantUtils.getTenantCode(), roleCodes);
    if (CollectionUtils.isEmpty(roleCodes)) {
      return;
    }
    Map<String, String> roleNameMap = roleVoSet.stream().collect(Collectors.toMap(RoleVo::getRoleCode, RoleVo::getRoleName, (key1, key2) -> key1));
    Map<String, Set<String>> positionRoleNameMap = Maps.newHashMap();
    positionVos.forEach(positionVo -> {
      if (CollectionUtils.isEmpty(positionVo.getRoleList())) {
        return;
      }
      Set<String> roleNames = positionVo.getRoleList().stream().map(roleNameMap::get)
          .filter(Objects::nonNull).collect(Collectors.toSet());
      positionRoleNameMap.put(positionVo.getPositionCode(), roleNames);
    });
    voList.forEach(positionPageVo -> {
      Set<String> roleNames = positionRoleNameMap.get(positionPageVo.getPositionCode());
      positionPageVo.setRoleName(CollectionUtils.isEmpty(roleNames) ? null : String.join(",", roleNames));
    });
  }

  /**
   * 封装职位报表数据用户信息
   *
   * @param voList 职位报表数据
   */
  public void buildUserInfo(List<PositionPageVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> positionCodes = voList.stream().map(PositionPageVo::getPositionCode).collect(Collectors.toList());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(Sets.newHashSet(positionCodes));
    if (CollectionUtils.isEmpty(userInfoVos)) {
      return;
    }
    Map<String, Set<String>> positionFullNameMap = userInfoVos.stream().collect(Collectors
        .groupingBy(UserInfoVo::getPositionCode, Collectors.mapping(UserInfoVo::getFullName, Collectors.toSet())));
    voList.forEach(positionPageVo -> {
      Set<String> fullNames = positionFullNameMap.get(positionPageVo.getPositionCode());
      positionPageVo.setFullName(CollectionUtils.isEmpty(fullNames) ? null : String.join(",", fullNames));
    });
  }

  /**
   * 封装职位报表数据用户信息
   *
   * @param voList 职位报表数据
   */
  public void buildOrgInfo(List<PositionPageVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    List<String> positionCodes = voList.stream().map(PositionPageVo::getPositionCode).collect(Collectors.toList());
    List<OrgPositionVo> orgPositionVos = this.orgPositionVoService.findByPositionCodes(positionCodes);
    if (CollectionUtils.isEmpty(orgPositionVos)) {
      return;
    }
    List<String> orgCodes = orgPositionVos.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toList());
    List<OrgVo> orgVos = this.orgVoService.findByOrgCodes(orgCodes);
    if (CollectionUtils.isEmpty(orgVos)) {
      return;
    }
    Map<String, OrgVo> orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (key1, key2) -> key1));
    Map<String, Set<String>> positionOrgNameMap = Maps.newHashMap();
    Map<String, Set<String>> positionOrgCodeMap = Maps.newHashMap();
    orgPositionVos.forEach(orgPositionVo -> {
      OrgVo orgVo = orgVoMap.get(orgPositionVo.getOrgCode());
      if (Objects.isNull(orgVo)) {
        return;
      }
      Set<String> orgCodeSet = positionOrgCodeMap.get(orgPositionVo.getPositionCode());
      Set<String> orgNameSet = positionOrgNameMap.get(orgPositionVo.getPositionCode());
      if (Objects.isNull(orgCodeSet)) {
        orgCodeSet = Sets.newHashSet();
      }
      if (Objects.isNull(orgNameSet)) {
        orgNameSet = Sets.newHashSet();
      }
      orgCodeSet.add(orgVo.getOrgCode());
      orgNameSet.add(orgVo.getOrgName());
      positionOrgCodeMap.put(orgPositionVo.getPositionCode(), orgCodeSet);
      positionOrgNameMap.put(orgPositionVo.getPositionCode(), orgNameSet);
    });
    voList.forEach(positionPageVo -> {
      Set<String> orgCodeSet = positionOrgNameMap.get(positionPageVo.getPositionCode());
      Set<String> orgNameSet = positionOrgCodeMap.get(positionPageVo.getPositionCode());
      positionPageVo.setOrgCode(CollectionUtils.isEmpty(orgCodeSet) ? null : String.join(",", orgCodeSet));
      positionPageVo.setOrgName(CollectionUtils.isEmpty(orgNameSet) ? null : String.join(",", orgNameSet));
    });
  }

}
