package com.biz.crm.mdm.admin.web.report.position.strategy.impl;

import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import com.biz.crm.mdm.admin.web.report.position.dto.UserSelectParentPositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.dto.UserSelectPositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.strategy.PositionReportStrategy;
import com.biz.crm.mdm.admin.web.report.position.strategy.helper.PositionReportStrategyHelper;
import com.biz.crm.mdm.admin.web.report.position.vo.PositionPageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户职位下拉框分页列表报表数据策略实现
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
@Component
public class UserSelectPositionReportStrategyImpl implements PositionReportStrategy<UserSelectPositionPageDto> {

  @Autowired(required = false)
  private PositionReportStrategyHelper positionReportStrategyHelper;

  @Override
  public String getPageSource() {
    return PositionReportConstant.POSITION_PAGE_SOURCE_USER_SELECT_POSITION_LIST;
  }

  @Override
  public Boolean onRequest(UserSelectPositionPageDto dto) {
    return true;
  }

  @Override
  public void onReturn(List<PositionPageVo> voList) {
    this.positionReportStrategyHelper.buildUnionName(voList);
  }
}
