package com.biz.crm.mdm.admin.web.report.positionlevel.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 职位级别列表查询条件Dto
 *
 * @author ning.zhang
 * @date 2021/11/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位级别列表查询条件Dto", description = "职位级别列表查询条件Dto")
public class PositionLevelPageDto extends TenantDto {


  /**
   * 数据状态（删除状态）
   */
  @ApiModelProperty("数据状态（删除状态）")
  private String delFlag;

  /**
   * 启用状态
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private List<String> orgCodes;

  /**
   * 职位级别编码
   */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;

  /**
   * 职位级别名称
   */
  @ApiModelProperty("职位级别名称 ")
  private String positionLevelName;

}
