package com.biz.crm.mdm.admin.web.report.positionlevel.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.admin.web.report.positionlevel.dto.PositionLevelPageDto;
import com.biz.crm.mdm.admin.web.report.positionlevel.repository.PositionLevelPageVoRepository;
import com.biz.crm.mdm.admin.web.report.positionlevel.service.PositionLevelPageVoService;
import com.biz.crm.mdm.admin.web.report.positionlevel.vo.PositionLevelPageVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * 职位级别分页Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/6/21
 */
@Service
@Slf4j
public class PositionLevelPageVoServiceImpl implements PositionLevelPageVoService {

  @Autowired
  private PositionLevelPageVoRepository positionLevelPageVoRepository;

  @Override
  public Page<PositionLevelPageVo> findByPositionLevelPageDto(Pageable pageable, PositionLevelPageDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new PositionLevelPageDto());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.positionLevelPageVoRepository.findByPositionLevelPageDto(pageable, dto);
  }
}
