package com.biz.crm.mdm.admin.web.report.product.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.product.dto.ProductReportPaginationDto;
import com.biz.crm.mdm.admin.web.report.product.service.ProductReportVoService;
import com.biz.crm.mdm.admin.web.report.product.vo.ProductReportVo;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/4
 */
@Slf4j
@Api(tags = "商品管理: ProductReportVo: 商品管理报表类分页")
@RestController
@RequestMapping(value = {"/v1/product/report"})
public class ProductReportVoController {

  @Autowired(required = false)
  private ProductReportVoService productReportVoService;

  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ProductReportVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      ProductReportPaginationDto paginationDto) {
    log.info("/v1/product/report/findByConditions,[{}]", paginationDto);
    try {
      paginationDto = Optional.ofNullable(paginationDto).orElse(new ProductReportPaginationDto());
      paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      Page<ProductReportVo> result = this.productReportVoService
          .findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
