package com.biz.crm.mdm.admin.web.report.product.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 商品report信息Vo
 *
 * @author sunx
 * @date 2021/11/4
 */
@Data
@ApiModel(value = "商品report信息Vo")
public class ProductReportVo {

  /**
   * 商品id
   */
  @ApiModelProperty("商品id")
  private String id;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 产品层级
   */
  @ApiModelProperty("产品层级")
  private String productLevelName;

  /**
   * 商品类型
   */
  @ApiModelProperty("商品类型")
  private String productType;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  private String baseUnit;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date beginDateTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date endDateTime;

  /**
   * 上下架状态
   */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /**
   * 启禁用状态
   */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 是否维护图片
   */
  @ApiModelProperty("是否维护图片")
  private Boolean maintenancePicture;

  /**
   * 是否维护详情
   */
  @ApiModelProperty("是否维护详情")
  private Boolean maintenanceIntroduction;

  /**
   * 销售公司
   */
  @ApiModelProperty("销售公司")
  private String saleCompany;

  /**
   * sfa图片地址
   */
  @ApiModelProperty("sfa图片地址")
  private String picUrl;

  /**
   * 主图片url
   */
  @ApiModelProperty("主图片url")
  private String primaryPictureUrl;

  /**
   * 价格
   */
  @ApiModelProperty("价格")
  private BigDecimal price;
}
