package com.biz.crm.mdm.admin.web.report.spu.repository;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.admin.web.report.spu.dto.AllowSaleListSpuModelDto;
import com.biz.crm.mdm.admin.web.report.spu.dto.AllowSaleListSpuProductCodeDto;
import com.biz.crm.mdm.admin.web.report.spu.mapper.AllowSaleListSpuVoMapper;
import com.biz.crm.mdm.admin.web.report.spu.model.AllowSaleListSpuModelVo;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商品SPU管理电商可购清单分页数据关联操作repository
 *
 * @author sunx
 * @date 2021/12/6
 */
@Component
public class AllowSaleListSpuVoRepository {

  @Autowired(required = false) private AllowSaleListSpuVoMapper allowSaleListSpuVoMapper;

  /**
   * 获取匹配的商品编码集合
   *
   * @param keyword
   * @param ruleCode
   * @param productCodeList
   * @return
   */
  public Set<String> findProductCodeSet(
      String keyword, String ruleCode, List<String> productCodeList) {
    AllowSaleListSpuProductCodeDto dto = new AllowSaleListSpuProductCodeDto();
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setIsShelf(IsShelfEnum.UP.getCode());
    dto.setKeyword(keyword);
    dto.setRuleCode(ruleCode);
    dto.setProductCodeList(productCodeList);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.allowSaleListSpuVoMapper.findProductCodeSetByAllowSaleListSpuProductCodeDto(dto);
  }

  /**
   * 获取匹配的spu编码及排序信息
   *
   * @param keyword
   * @param spuTagList
   * @param productCodeList
   * @return
   */
  public List<AllowSaleListSpuModelVo> findAllowSaleListSpuModelVoList(
      String keyword, List<String> spuTagList, List<String> productCodeList) {
    AllowSaleListSpuModelDto dto = new AllowSaleListSpuModelDto();
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setIsShelf(IsShelfEnum.UP.getCode());
    dto.setKeyword(keyword);
    dto.setProductCodeList(productCodeList);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setSpuTagList(spuTagList);
    return this.allowSaleListSpuVoMapper.findAllowSaleListSpuModelVoList(dto);
  }


  /**
   * 精准获取匹配的spu编码及排序信息
   *
   * @param keyword
   * @param spuTagList
   * @param productCodeList
   * @return
   */
  public List<AllowSaleListSpuModelVo> findPreciseAllowSaleListSpuModelVoList(
      String keyword, List<String> spuTagList, List<String> productCodeList) {
    AllowSaleListSpuModelDto dto = new AllowSaleListSpuModelDto();
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setIsShelf(IsShelfEnum.UP.getCode());
    dto.setKeyword(keyword);
    dto.setProductCodeList(productCodeList);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setSpuTagList(spuTagList);
    return this.allowSaleListSpuVoMapper.findPreciseAllowSaleListSpuModelVoList(dto);
  }
}
