package com.biz.crm.mdm.admin.web.report.terminal.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.report.terminal.dto.NoRelaCurTerminalDto;
import com.biz.crm.mdm.admin.web.report.terminal.dto.NoRelaTerminalDto;
import com.biz.crm.mdm.admin.web.report.terminal.dto.RelaCurTerminalDto;
import com.biz.crm.mdm.admin.web.report.terminal.dto.TerminalReportPaginationDto;
import com.biz.crm.mdm.admin.web.report.terminal.service.TerminalReportVoService;
import com.biz.crm.mdm.admin.web.report.terminal.vo.TerminalReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/5
 */
@Slf4j
@Api(tags = "终端管理: TerminalReportVo: 终端报表类分页")
@RestController
@RequestMapping(value = {"/v1/terminal/report"})
public class TerminalReportVoController {

  @Autowired(required = false)
  private TerminalReportVoService terminalReportVoService;

  /**
   * 无供货关系类分页列表,适用功能【终端信息分页、企业组织终端维护、客户组织关联终端】
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "无供货关系类分页列表,适用功能【终端信息分页、企业组织终端维护、客户组织关联终端】")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<TerminalReportVo>> findByConditions(@PageableDefault(50) Pageable pageable,
      TerminalReportPaginationDto paginationDto) {
    log.info("/v1/terminal/report/findByConditions,[{}]", paginationDto);
    try {
      paginationDto = Optional.ofNullable(paginationDto).orElse(new TerminalReportPaginationDto());
      paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      Page<TerminalReportVo> result = this.terminalReportVoService
          .findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 未关联当前分页列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "未关联当前分页列表")
  @GetMapping("/findByNoRelaCurTerminalDto")
  public Result<Page<TerminalReportVo>> findByNoRelaCurTerminalDto(
      @PageableDefault(50) Pageable pageable, NoRelaCurTerminalDto dto) {
    try {
      return Result.ok(this.terminalReportVoService
          .findByNoRelaCurTerminalDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 未关联任何分页列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "未关联任何分页列表")
  @GetMapping("/findByNoRelaTerminalDto")
  public Result<Page<TerminalReportVo>> findByNoRelaTerminalDto(
      @PageableDefault(50) Pageable pageable, NoRelaTerminalDto dto) {
    try {
      return Result
          .ok(this.terminalReportVoService
              .findByNoRelaTerminalDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 已关联当前分页列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "已关联当前分页列表")
  @GetMapping("/findByRelaCurTerminalDto")
  public Result<Page<TerminalReportVo>> findByRelaCurTerminalDto(
      @PageableDefault(50) Pageable pageable, RelaCurTerminalDto dto) {
    try {
      return Result.ok(this.terminalReportVoService
          .findByRelaCurTerminalDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
