package com.biz.crm.mdm.admin.web.report.terminal.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 非常关键
 * <p></p>
 * 企业用户查询时必传userName参数
 * <p>
 * 客户用户查询时必传customerUserName
 * </p>
 * 客户查询时必传customerCode
 *
 * @author sunx
 * @date 2021/11/17
 */
@Data
@ApiModel(value = "RelaCurTerminalDto", description = "有供货关系类终端report分页查询dto-关联了当前客户，客户用户，企业用户")
public class RelaCurTerminalDto extends TerminalSupplyReportPaginationDto {

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;

  /**
   * 客户用户账号信息
   */
  @ApiModelProperty(value = "客户用户账号信息")
  private String customerUserName;

  /**
   * 用来获取positionCodeList进行查询
   */
  @ApiModelProperty(value = "企业用户账号信息")
  private String userName;

  /**
   * 用于下拉列表选择,输入回显编码集合，字符串集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
   */
  @ApiModelProperty("用于下拉列表选择,输入回显编码集合，字符串集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCode;
}
