package com.biz.crm.mdm.admin.web.report.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.terminal.repository.TerminalReportVoRepository;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalClientDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalClientVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalTagVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalClientVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalTagVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 终端客户voService实现类
 *
 * @author songjingen
 */
@Service
public class TerminalClientVoServiceImpl implements TerminalClientVoService {

  @Autowired(required = false)
  private TerminalReportVoRepository terminalReportVoRepository;
  @Autowired(required = false)
  private TerminalContactService terminalContactService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private TerminalTagVoService terminalTagVoService;


  @Override
  public Page<TerminalClientVo> findChildrenPageByTerminalClientDto(Pageable pageable, TerminalClientDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null || StringUtils.isAnyBlank(dto.getUserName())) {
      return new Page<>();
    }
    if (StringUtils.isBlank(dto.getTenantCode())) {
      dto.setTenantCode(TenantUtils.getTenantCode());
    }
    Page<TerminalClientVo> page = this.terminalReportVoRepository.findChildrenPageByTerminalClientDto(pageable, dto);
    List<TerminalClientVo> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    //组装关联数据
    this.buildTerminalClientVos(records);
    return page;
  }

  /**
   * 组装关联数据
   *
   * @param records
   */
  private void buildTerminalClientVos(List<TerminalClientVo> records) {
    List<String> terminalCodes = records.stream().map(TerminalClientVo::getTerminalCode).collect(Collectors.toList());
    //查看联系人
    List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodes);
    Map<String, List<TerminalContactVo>> terminalContactVoMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(terminalContactList)) {
      List<TerminalContactVo> terminalContactVos = (List<TerminalContactVo>) this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class);
      terminalContactVoMap = terminalContactVos.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
    }
    //查看标签
    Map<String, List<TerminalTagVo>> tagVoMap = new HashMap<>();
    List<TerminalTagVo> tagVos = this.terminalTagVoService.findByTerminalCodes(new HashSet<>(terminalCodes));
    if (!CollectionUtils.isEmpty(tagVos)) {
      tagVoMap = tagVos.stream().collect(Collectors.groupingBy(TerminalTagVo::getTerminalCode));
    }
    //赋值
    for (TerminalClientVo terminalClientVo : records) {
      String terminalCode = terminalClientVo.getTerminalCode();
      terminalClientVo.setContacts(terminalContactVoMap.get(terminalCode));
      terminalClientVo.setTags(tagVoMap.get(terminalCode));
    }
  }
}
