package com.biz.crm.mdm.admin.web.report.user.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.report.user.dto.UserUnderlingDto;
import com.biz.crm.mdm.admin.web.report.user.service.UserUnderlingVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserUnderlingVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户下属(User)表控制层
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Slf4j
@Api(tags = "MDM管理后台BOOT：UserUnderlingVo: 用户下属")
@RestController
@RequestMapping(value = {"/v1/adminWeb/userUnderling"})
public class UserUnderlingVoController {

  @Autowired(required = false)
  private UserUnderlingVoService userUnderlingVoService;

  /**
   * 分页查询用户下属列表
   *
   * @param dto 用户下属参数对象
   * @return Result<List<UserUnderlingVo>>
   */
  @ApiOperation(value = "分页查询用户下属列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<UserUnderlingVo>> findByConditions(@PageableDefault(50) Pageable pageable, UserUnderlingDto dto) {
    try {
      Page<UserUnderlingVo> result = this.userUnderlingVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
