package com.biz.crm.mdm.admin.web.report.user.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.admin.web.report.user.dto.UserUnderlingDto;
import com.biz.crm.mdm.admin.web.report.user.mapper.UserUnderlingMapper;
import com.biz.crm.mdm.admin.web.report.user.vo.UserUnderlingVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * 用户下属(repository)
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:02
 */
@Component
public class UserUnderlingRepository {

  @Autowired(required = false)
  private UserUnderlingMapper userUnderlingMapper;

  /**
   * 分页查询用户下属列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<UserUnderlingVo> findByConditions(Pageable pageable, @Param("dto") UserUnderlingDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    Page<UserUnderlingDto> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto = Optional.ofNullable(dto).orElse(new UserUnderlingDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return this.userUnderlingMapper.findByConditions(page, dto);
  }

}
