package com.biz.crm.mdm.admin.web.report.user.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.admin.web.report.user.dto.UserDetailDto;
import com.biz.crm.mdm.admin.web.report.user.repository.UserDetailRepository;
import com.biz.crm.mdm.admin.web.report.user.service.UserDetailVoService;
import com.biz.crm.mdm.admin.web.report.user.vo.UserDetailVo;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * 用户详细信息服务实现类
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:03
 */
@Slf4j
@Service
public class UserDetailVoServiceImpl implements UserDetailVoService {

  @Autowired(required = false)
  private UserDetailRepository userDetailRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private UserPositionVoService userPositionVoService;

  @Override
  public List<UserDetailVo> findByUserName(UserDetailDto dto) {
    if (StringUtils.isBlank(dto.getUserName())) {
      return null;
    }
    return this.userDetailRepository.findByUserName(dto);
  }

  @Override
  public UserDetailVo findDetailByLoginUser() {
    LoginUserDetails loginUserDetails = loginUserService.getLoginDetails(LoginUserDetails.class);
    if (loginUserDetails == null || StringUtils.isBlank(loginUserDetails.getTenantCode()) || StringUtils.isBlank(loginUserDetails.getAccount())) {
      return null;
    }
    List<UserPositionVo> userPositionVos = this.userPositionVoService.findByUserName(loginUserDetails.getTenantCode(), loginUserDetails.getAccount());
    Validate.notEmpty(userPositionVos, "请先给当前用户设置岗位");
    Optional<UserPositionVo> currentFlagVo = userPositionVos.stream()
        .filter(r-> Boolean.TRUE.equals(r.getCurrentFlag()))
        .findFirst();
    Validate.isTrue(currentFlagVo.isPresent(), "请先给当前用户设置当前岗位");
    UserDetailDto dto = new UserDetailDto();
    dto.setUserName(loginUserDetails.getAccount());
    dto.setPostCode(currentFlagVo.get().getPositionCode());
    List<UserDetailVo> userDetailVos = this.findByUserName(dto);
    if (CollectionUtils.isEmpty(userDetailVos)) {
      return null;
    }
    return userDetailVos.get(0);
  }

}
