package com.biz.crm.mdm.admin.web.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author hecheng
 * @description: 一个默认的生成编码
 * @date 2021/10/8 下午2:00
 */
@Service
public class DefaultGenerateCodeServiceImpl implements GenerateCodeService {

  /**
   * code生成规则
   */
  private final static String KEY_FORMAT = "%s:code:index:%s";
  @Autowired(required = false)
  private RedisMutexService redisMutexService;

  @Override
  public List<String> generateCode(String ruleCode, int number) {
    List<String> codes = Lists.newArrayList();
    String key = String.format(KEY_FORMAT, ruleCode, TenantUtils.getTenantCode());
    for (int i = 0; i < number; i++) {
      String index = redisMutexService.getAndIncrement(key, 1, 8);
      codes.add(StringUtils.join(ruleCode, index));
    }
    return codes;
  }

  @Override
  public List<String> generateCode(String ruleCode, int number, Integer mixStrLen, long expire, TimeUnit unit) {
    List<String> codes = Lists.newArrayList();
    String key = String.format(KEY_FORMAT, ruleCode, TenantUtils.getTenantCode());
    for (int i = 0; i < number; i++) {
      String index = redisMutexService.getAndIncrement(key, 1, mixStrLen, expire, unit);
      codes.add(StringUtils.join(ruleCode, index));
    }
    return codes;
  }
}
