package com.biz.crm.mdm.admin.web.strategy.internal;

import com.biz.crm.business.common.sdk.enums.LoginFromTypeEnum;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.biz.crm.mdm.admin.web.strategy.LoginUserManageStrategy;
import com.biz.crm.mdm.business.user.sdk.dto.UserForceChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;

/**
 * 后台管理登录账号信息管理策略实现
 *
 * @author pengxi
 */
@Service
public class ConsoleLoginUserManageStrategyImpl implements LoginUserManageStrategy {

  @Autowired(required = false)
  private UserVoService userVoService;

  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;

  @Autowired(required = false)
  private UserValidityCheckService userValidityCheckService;

  @Override
  public LoginFromTypeEnum loginFromTypeEnum() {
    return LoginFromTypeEnum.CONSOLE;
  }

  @Override
  public void updatePasswordByPhoneAndVerificationCode(String phone, String password, String verificationCode) {
    // 根据设备端类型+登录手机号检查用户有效性
    Boolean isAvailable = this.validitySmsCodeService.isAvailableVerificationCode(phone, verificationCode);
    Validate.isTrue(isAvailable, "验证码过期或不正确，请重新获取！");
    UserVo userVo = this.userVoService.findByPhone(phone);
    Validate.notNull(userVo, "当前系统不存在此手机号，请先注册！");
    UserForceChangePasswordDto dto = new UserForceChangePasswordDto();
    dto.setIds(Collections.singletonList(userVo.getId()));
    dto.setPassword(password);
    this.userVoService.updatePasswordByIds(dto);
  }

  @Override
  public void verificationByPhone(String phone) {
    this.userValidityCheckService.verificationManageByPhone(phone);
  }
}
