package com.biz.crm.mdm.admin.web.strategy.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.mdm.admin.web.strategy.DefaultAuthenticationDecisionStrategy;
import com.biz.crm.mdm.business.user.sdk.constant.UserConstant;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.Aes128Utils;
import com.bizunited.nebula.security.sdk.event.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.event.DecisionTypes;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;

/**
 * 典型的账户名+密码方式策略实现
 *
 * @author pengxi
 */
@Slf4j
@Component
public class DefaultAccountAndPasswordStrategy extends DefaultAuthenticationDecisionStrategy implements AuthenticationDecisionStrategy {

  @Autowired(required = false)
  private UserValidityCheckService userValidityCheckService;

  @Override
  public DecisionTypes type() {
    return DecisionTypes.ACCOUNTANDPASSWORD;
  }

  @Override
  public boolean onAuthenticate(LoginDetails loginDetails) {
    /*
     * 处理过程如下：
     * 1、首先通过登录账号查询当前用户并检查用户有效性
     * 2、检查登录密码是否正确
     * 3、然后完善登录信息中的用户基本信息
     * 4、最后完善登录信息中的岗位组织等信息
     */
    LoginUserDetails loginUserDetails = (LoginUserDetails) loginDetails;
    log.info("HttpServletRequest account:{}", loginUserDetails.getAccount());
    log.info("HttpServletRequest password:{}", loginUserDetails.getPassword());
    Validate.notBlank(loginUserDetails.getAccount(), "登录账号不能为空！");
    Validate.notBlank(loginUserDetails.getPassword(), "登录密码不能为空！");
    String account = Aes128Utils.decrypt(loginUserDetails.getAccount(), UserConstant.ENCRYPT_KEY, Aes128Utils.EncodeType.CBC, Aes128Utils.Padding.PKCS_7_PADDING);
    log.error("account decrypt:{}", account);
    // 1、
    UserVo userVo = this.userValidityCheckService.verificationManageByAccount(account);
    // 2、密码校验过程先按与前端约定的加密方式做解密，然后md5再做校验
    String password = Aes128Utils.decrypt(loginUserDetails.getPassword(), UserConstant.ENCRYPT_KEY, Aes128Utils.EncodeType.CBC, Aes128Utils.Padding.PKCS_7_PADDING);
    log.error("password decrypt:{}", password);
    String passwordEncryption = DigestUtils.md5DigestAsHex(password.getBytes(StandardCharsets.UTF_8));
    Validate.isTrue(passwordEncryption.equals(userVo.getUserPassword()), "登录密码错误！");
    // 3、
    loginUserDetails.setType(DecisionTypes.ACCOUNTANDPASSWORD.getCode());
    super.perfectLoginUserDetails(userVo, loginUserDetails);
    // 4、
    super.perfectLoginPostAndOrg(loginUserDetails);
    return true;
  }
}
