package com.biz.crm.mdm.admin.web;

import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.autoconfigure.RocketMQAutoConfiguration;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * MDM后台管理启动程序
 */
@SpringBootApplication(scanBasePackages = {"com.biz.crm.*", "com.bizunited.nebula.*"},exclude = RocketMQAutoConfiguration.class)
@MapperScan(value = {"com.biz.crm.**.mapper*", "com.bizunited.nebula.**.mapper*"})
@EnableTransactionManagement
@Slf4j
@EnableDiscoveryClient
@EnableElasticsearchRepositories(basePackages = "com.biz.crm.**.repository*")
@EnableFeignClients(basePackages = "com.biz.crm.*")
public class MdmWebBootstrap {

    public static void main(String[] args) {

        System.setProperty("es.set.netty.runtime.available.processors", "false");
        ConfigurableApplicationContext application =
                new SpringApplicationBuilder(MdmWebBootstrap.class).bannerMode(Banner.Mode.OFF)
                        .web(WebApplicationType.SERVLET).run(args);

        Environment env = application.getEnvironment();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\t"
                + "Application crm-mdm is running! Access URLs:\n\t" //
                + "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t"
                + "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n"
                + "----------------------------------------------------------");

    }

}
