package com.biz.crm.mdm.admin.web.config;

import com.biz.crm.mdm.admin.web.filter.LoginLimitFilter;
import com.bizunited.nebula.security.sdk.config.NebulaWebSecurityConfigurerAdapter;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

import java.time.Duration;

/**
 * 描述：</br>登录错误处理拦截器配置类
 *
 * @author keller
 * @date 2022/10/19
 */
@Configuration
@Slf4j
@Data
public class LoginLimitConfig implements NebulaWebSecurityConfigurerAdapter {
  /**
   * 触发错误次数
   */
  @Value("${security.login.failedTimes:5}")
  private Integer failedTimes;

  /**
   * 锁定时间
   */
  @Value("${security.login.lockTime:10m}")
  private Duration lockTime;

  /**
   * 登录超时时间/小时
   */
  @Value("${security.login.outTime:10h}")
  private Duration outTime;

  @Bean
  public LoginLimitFilter buildLoginLimitFilter() {
    LoginLimitFilter loginLimitFilter = new LoginLimitFilter();
    return loginLimitFilter;
  }

  @Override
  public void configure(HttpSecurity http) throws Exception {
    log.debug("add login limit filter success");
    http.addFilterBefore(buildLoginLimitFilter(), UsernamePasswordAuthenticationFilter.class);
  }
}
