package com.biz.crm.mdm.admin.web.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.biz.crm.mdm.admin.web.notifier.LoginFailedAuthenticatedEventListener;
import com.biz.crm.mdm.admin.web.service.SmsVerificationCodeService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 管理端发送手机号验证码相关接口
 *
 * @author pengxi
 * @date 2022/05/10
 */
@Slf4j
@RestController
@RequestMapping("/v1/smsVerificationCode/smsVerificationCode")
@Api(tags = "管理端发送手机号验证码相关接口")
public class SmsVerificationCodeController {

  @Autowired(required = false)
  private SmsVerificationCodeService smsVerificationCodeService;

  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;

  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;

  @Autowired
  private LoginFailedAuthenticatedEventListener loginFailedAuthenticatedEventListener;

  @Autowired
  private RedisMutexService redisMutexService;

  @Autowired
  private StringRedisTemplate stringRedisTemplate;


  @ApiOperation(value = "校验手机号验证码是否有效")
  @PostMapping("/checkVerificationCode")
  public Result<?> checkVerificationCode(
          @RequestParam(value = "appType") @ApiParam(name = "appType", required = true, value = "业务系统类型") Integer appType,
          @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone,
          @RequestParam(value = "verificationCode") @ApiParam(name = "verificationCode", required = true, value = "短信验证码") String verificationCode) {
    try {
      Boolean bool = this.validitySmsCodeService.isAvailableVerificationCode(phone, verificationCode);
      return Result.ok(bool);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "发送【手机号+验证码登录时】手机号验证码")
  @PostMapping("/sendPhoneLoginVerificationCode")
  public Result<?> sendPhoneLoginVerificationCode(
          @RequestParam(value = "appType") @ApiParam(name = "appType", required = true, value = "业务系统类型") Integer appType,
          @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone) {
    try {
      this.smsVerificationCodeService.phoneLoginVerificationCode(appType, phone);
      return Result.ok("验证码发送成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "发送【找回密码时】手机号验证码")
  @PostMapping("/sendRetrievePasswordVerificationCode")
  public Result<?> sendRetrievePasswordVerificationCode(
          @RequestParam(value = "appType") @ApiParam(name = "appType", required = true, value = "业务系统类型") Integer appType,
          @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone) {
    try {
      this.smsVerificationCodeService.retrievePasswordVerificationCode(appType, phone);
      return Result.ok("验证码发送成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "管理员解除登录失败限制")
  @GetMapping("/releaseLoginLimit")
  public Result<?> sendRetrievePasswordVerificationCode(
          @RequestParam(value = "userAccount") @ApiParam(name = "userAccount", required = true, value = "登录名") String userAccount,
          @RequestParam(value = "loginType") @ApiParam(name = "loginType", required = true, value = "登录类型") Integer loginType) {
    if (StringUtils.isBlank(userAccount)) {
      return Result.error("请传入登录名");
    }
    if (loginType == null) {
      loginType = this.simpleSecurityProperties.getDefaultLoginType();
    }
    String account = StringUtils.join(loginType, "_", userAccount);
    String key = String.format(loginFailedAuthenticatedEventListener.LOGIN_LOCK_KEY, TenantUtils.getTenantCode(), account);
    String redisKey = String.format(loginFailedAuthenticatedEventListener.LOGIN_FAILED_KEY, TenantUtils.getTenantCode(), account);
    try {
      this.redisMutexService.lock(key);
      String loginFailedTimeStr = this.stringRedisTemplate.opsForValue().get(redisKey);
      if (StringUtils.isNotBlank(loginFailedTimeStr)) {
        this.stringRedisTemplate.delete(redisKey);
      }
    } catch (Exception ex) {
      log.error(ex.getMessage(), ex);
      throw new RuntimeException(ex.getMessage(), ex);
    } finally {
      if (this.redisMutexService.islock(key)) {
        this.redisMutexService.unlock(key);
      }
    }
    return Result.ok("解除成功！");
  }


}
