package com.biz.crm.mdm.admin.web.dataPermission.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.admin.web.dataPermission.dto.DataPermissionDto;
import com.biz.crm.mdm.admin.web.dataPermission.service.DataPermissionService;
import com.biz.crm.mdm.admin.web.dataPermission.vo.DataPermissionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: chenlong
 * @date: 2023/2/13 14:25
 * @description: 数据权限相关接口
 */
@Slf4j
@RestController
@RequestMapping("/v1/dataPermission")
@Api(tags = "数据权限相关接口")
public class DataPermissionController {

    @Autowired(required = false)
    private DataPermissionService dataPermissionService;

    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<DataPermissionVo>> findByConditions(@PageableDefault(50) Pageable pageable, DataPermissionDto dataPermissionDto) {
        try {
            Page<DataPermissionVo> result = this.dataPermissionService.findByConditions(pageable, dataPermissionDto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
