package com.biz.crm.mdm.admin.web.dataPermission.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2022/11/8 20:00
 * @description: 数据权限主体注册器分类 枚举
 */
public enum ScopeEnum {
    /**
     * 组织
     */
    ORG("org", "org_scope,org_tree_scope,org_up_tree_scope", "组织"),
    /**
     * 职位
     */
    POSITION("position", "position_scope", "职位"),
    /**
     * 角色
     */
    ROLE("role", "role_scope", "角色"),
    /**
     * 销售组织
     */
    SALES_ORG("sales_org", "sales_org_scope,sales_org_tree_scope", "销售组织"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String value;
    private String des;

    ScopeEnum(String code, String value, String des) {
        this.code = code;
        this.value = value;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public String getDes() {
        return this.des;
    }

    public static ScopeEnum codeToEnum(String code) {
        ScopeEnum scopeEnum = null;
        ScopeEnum[] var2 = values();

        for (ScopeEnum scopeEnum1 : var2) {
            if (scopeEnum1.code.equals(code)) {
                scopeEnum = scopeEnum1;
            }
        }

        return scopeEnum;
    }
}
