package com.biz.crm.mdm.admin.web.dataPermission.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.admin.web.dataPermission.dto.DataPermissionDto;
import com.biz.crm.mdm.admin.web.dataPermission.mapper.DataPermissionMapper;
import com.biz.crm.mdm.admin.web.dataPermission.vo.DataPermissionVo;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * @author: chenlong
 * @date: 2023/2/14 9:46
 * @description: 数据权限数据访问层
 */
@Repository
public class DataPermissionRepository extends ServiceImpl<DataPermissionMapper, MarsAuthorityEntity> {

    @Autowired(required = false)
    private DataPermissionMapper dataPermissionMapper;

    /**
     * 数据权限分页信息
     *
     * @param pageable          分页参数
     * @param dataPermissionDto 筛选参数
     * @return Page<DataPermissionVo>
     */
    public Page<DataPermissionVo> findByConditions(Pageable pageable, DataPermissionDto dataPermissionDto) {
        Page<DataPermissionVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.dataPermissionMapper.findByConditions(page, dataPermissionDto);
    }


}
